package managed_beans;

import entities.Diplomski;
import entities.Korisnik;
import jakarta.annotation.PostConstruct;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import util.SessionUtils;
import util.dao.DiplomskiDAO;

@Named(value = "n")
@ViewScoped
public class NastavnikManagedBean implements Serializable {

    public NastavnikManagedBean() {
    }

    DiplomskiDAO dAO = new DiplomskiDAO();

    Korisnik ulogovan = (Korisnik) SessionUtils.getAttribute("korisnik");
    private List<Diplomski> neodbranjeni = new ArrayList<>();
    private int br = 0;
    private String greska;

    public List<Diplomski> getNeodbranjeni() {
        return neodbranjeni;
    }

    public void setNeodbranjeni(List<Diplomski> neodbranjeni) {
        this.neodbranjeni = neodbranjeni;
    }

    public int getBr() {
        return br;
    }

    public void setBr(int br) {
        this.br = br;
    }

    public String getGreska() {
        return greska;
    }

    @PostConstruct
    public void init() {

        List<Diplomski> svi = dAO.getAllForTeacher(ulogovan.getKorisnicko_ime());

        for (Diplomski d : svi) {
            if (d.getOcena() != null) {
                br++;
            } else {
                neodbranjeni.add(d);
            }
        }
    }

    public String prihvati(Diplomski d) {
        if (d.getOcena() == null || d.getOcena() < 6 || d.getOcena() > 10) {
            greska = "Uneta ocena mora biti broj izmedju 6 i 10";
            return "";
        }
        int res = dAO.edit(d);
        if (res == 0) {
            greska = "Doslo je do greske";
            return null;
        }
        return "nastavnik";
    }

    public String odbij(Diplomski d) {
        int res = dAO.delete(d);
        if (res == 0) {
            greska = "Doslo je do greske";
            return null;
        }
        return "nastavnik";
    }
}
