package util.dao;

import entities.Reservation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DateConverter;

public class ReservationDAO implements ReservationDAOInterface {

    @Override
    public List<Reservation> getAllReservations() {

        List<Reservation> all = new ArrayList<>();
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("select * from rezervacija order by datumOd");) {

            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Reservation r = new Reservation();
                r.setFrom(rs.getTimestamp("datumOd"));
                r.setTo(rs.getTimestamp("datumDo"));
                r.setTitle(rs.getString("naziv"));
                r.parseAndSetLabs(rs.getString("prostorije"));
                r.setId(rs.getInt("id"));
                all.add(r);
            }

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return all;
    }

    @Override
    public List<Reservation> getAllReservationsBetween(Date from, Date to) {

        List<Reservation> all = new ArrayList<>();
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("select * from rezervacija where (? > datumOd and ? < datumDo) or (? > datumOd and ? < datumDo)");) {
            // moze i between, ali tu ce naci preklapanje ako je kraj jednog termina pocetak drugog

            Timestamp begin = new Timestamp(from.getTime());
            Timestamp end = new Timestamp(to.getTime());
            ps.setTimestamp(1, begin);
            ps.setTimestamp(2, begin);
            ps.setTimestamp(3, end);
            ps.setTimestamp(4, end);

            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Reservation r = new Reservation();
                r.setFrom(rs.getTimestamp("datumOd"));
                r.setTo(rs.getTimestamp("datumDo"));
                r.setTitle(rs.getString("naziv"));
                r.parseAndSetLabs(rs.getString("prostorije"));
                r.setId(rs.getInt("id"));
                all.add(r);
            }

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return all;
    }

    @Override
    public boolean insertReservation(Reservation r) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("insert into rezervacija (naziv,datumOd,datumDo,prostorije) values(?,?,?,?)");) {
            ps.setString(1, r.getTitle());
            ps.setTimestamp(2, new Timestamp(r.getFrom().getTime()));
            ps.setTimestamp(3, new Timestamp(r.getTo().getTime()));
            ps.setString(4, r.labsToString());

            return ps.executeUpdate() != 0;

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return false;
    }

    @Override
    public boolean insertReservation2(Reservation r) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("insert into rezervacija (naziv,datumOd,datumDo,prostorije) values(?,?,?,?)");) {
            ps.setString(1, r.getTitle());
            ps.setString(2, DateConverter.utilToString(r.getFrom()));
            ps.setString(3, DateConverter.utilToString(r.getTo()));
            ps.setString(4, r.labsToString());

            return ps.executeUpdate() != 0;

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return false;
    }

    @Override
    public boolean deleteReservation(Reservation r) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("delete from rezervacija where id=?");) {
            ps.setInt(1, r.getId());

            return ps.executeUpdate() != 0;

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return false;
    }
}
