package managed_beans;

import entities.User;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.dao.UserDAO;

@Named(value = "registrationMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class RegistrationManagedBean {

    private User novi = new User();
    private String poruka;

    public User getNovi() {
        return novi;
    }

    public void setNovi(User novi) {
        this.novi = novi;
    }

    public String getPoruka() {
        return poruka;
    }

    public String registracija() {
        UserDAO userDAO = new UserDAO();
        poruka = "Korisnicko ime je zauzeto!"; // podrazumevano, pa cemo promeniti ako treba

        if (!userDAO.usernameExists(novi.getUsername())) {
            if (userDAO.insertUser(novi)) {
                poruka = "Uspeh!";
                novi = new User();
            } else {
                poruka = "Doslo je do greske prilikom unosa.";
            }
        }
        return null;
    }
}
