package managed_beans;

import entities.User;
import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import util.dao.UserDAO;

@Named(value = "loginManagedBean")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class LoginManagedBean implements Serializable {

    private String username;
    private String password;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private String poruka;

    public String getPoruka() {
        return poruka;
    }

    public void setPoruka(String poruka) {
        this.poruka = poruka;
    }

    public String login() {
        User k = new UserDAO().login(username, password);
        if (k == null) {
            //System.out.println("nema korisnika");
            poruka = "Pogresno korisnicko ime ili lozinka";
            return null;
        } else {
            //System.out.println("ima korisnika");
            HttpSession session = util.SessionUtils.getSession();
            session.setAttribute("korisnik", k);

            if ("nastavnik".equalsIgnoreCase(k.getType())) {
                return "nastavnik";
            } else if ("laborant".equalsIgnoreCase(k.getType())) {
                return "laborant";
            } else {
                poruka = "Nepoznat tip korisnika";
                return "index";
            }
        }
    }

    public String logout() {
        HttpSession session = util.SessionUtils.getSession();
        session.invalidate();
        return "index";
    }
}
