package managed_beans;

import entities.Reservation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.dao.ReservationDAO;

@Named(value = "labAssistantMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class LabAssistantManagedBean {

    private List<Reservation> all = new ArrayList<>();
    private String poruka;

    @PostConstruct
    public void fetchAllReservations() {
        ReservationDAO reservationDAO = new ReservationDAO();
        all = reservationDAO.getAllReservations();
    }

    public List<Reservation> getAll() {
        return all;
    }

    public String getPoruka() {
        return poruka;
    }

    public String deleteReservation(Reservation r) {
        if (!(new ReservationDAO().deleteReservation(r))) {
            poruka = "Doslo je do greske pri brisanju.";
        } else {
            poruka = "";
            // da bi se i na stranici videla izmena, rucno cemo obrisati iz liste
            all.remove(r);
        }
        return "laborant";
    }
}
