package entities;

import java.util.Date;
import util.DateConverter;

public class Reservation {

    private int id;
    private String title;
    private Date from;
    private Date to;
    private String[] labs;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public String[] getLabs() {
        return labs;
    }

    public void setLabs(String[] labs) {
        this.labs = labs;
    }

    public void parseAndSetLabs(String oneString) {
        this.labs = oneString.split(",");
    }

    public String labsToString() {
        return String.join(",", this.labs);
    }

    public String getPrettyFrom() {
        return DateConverter.utilToString(from, "dd.MM.yyyy. HH:mm");
    }

    public String getPrettyTo() {
        return DateConverter.utilToString(to, "dd.MM.yyyy. HH:mm");
    }

    @Override
    public String toString() {
        return String.format("(%d) %s %s - %s [%s]", id, title, DateConverter.utilToString(from), DateConverter.utilToString(to), labsToString());
    }

}
