/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package util.dao;

import entities.User;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author jelica
 */
public class UserDAO implements UserDAOInterface {

    @Override
    public User login(String username, String password) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("select * from korisnik where korisnickoIme=? and lozinka=?");) {

            ps.setString(1, username);
            ps.setString(2, password);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                User k = new User();

                k.setUsername(rs.getString("korisnickoIme"));
                k.setPassword(rs.getString("lozinka"));
                k.setFirstName(rs.getString("ime"));
                k.setLastName(rs.getString("prezime"));
                k.setGender(rs.getString("pol"));
                k.setType(rs.getString("tip"));

                return k;
            }

            return null;
        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }

        return null;
    }

    @Override
    public boolean usernameExists(String username) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("select * from korisnik where korisnickoIme=?");) {
            ps.setString(1, username);

            ResultSet rs = ps.executeQuery();

            return rs.next();

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }
        return false;
    }

    @Override
    public boolean insertUser(User k) {
        Connection conn = util.DB.getInstance().getConnection();
        try (PreparedStatement ps = conn.prepareStatement("insert into korisnik values(?,?,?,?,?,?)");) {

            // posto nismo eksplicitno naveli imena kolona, pratimo redosled kojim su navedene u tabeli
            ps.setString(1, k.getFirstName());
            ps.setString(2, k.getLastName());
            ps.setString(3, k.getGender());
            ps.setString(4, k.getUsername());
            ps.setString(5, k.getPassword());
            ps.setString(6, k.getType());

            return ps.executeUpdate() != 0;
            // executeUpdate vraca 0 ako je doslo do greske

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            util.DB.getInstance().putConnection(conn);
        }
        return false;
    }
}
