package util.dao;

import entities.Manifestation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DB;

public class ManifestationDAO {

    public ArrayList<Manifestation> getAllManifestations() {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return null;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        try (PreparedStatement ps = con.prepareStatement("select * from manifestations")) {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Manifestation m = new Manifestation();
                m.setId(rs.getInt("id"));
                m.setName(rs.getString("name"));
                m.setType(rs.getString("type"));
                m.setStatus(rs.getString("status"));
                m.setOrganizer(rs.getString("organizer"));

                // datum se cuva kao java.sql.Date, pa se kao takav i cita,
                // mada moze da se cita (i ubacuje) i kao string u yyyy-MM-dd formatu, pa da se onda parsira po potrebi
                java.sql.Date start = rs.getDate("date_from");
                m.setDateFrom(start.toLocalDate());
                // ili u jednoj naredbi
                m.setDateTo(rs.getDate("date_to").toLocalDate());
                // a moze i kao string da se procita u string ili java.util.Date promenljivu
                m.setDateFromString(rs.getString("date_from"));
                m.setDateToString(rs.getString("date_to"));
                // ili iz stringa u LocalDate
                m.setDateFrom(LocalDate.parse(rs.getString("date_from")));
                m.setDateTo(LocalDate.parse(rs.getString("date_to")));
                // a moze i iz java.sql.Date u java.util.Date
                // pomocu java.util.Date(sqlDate.getTime())

                // kako god je najlakse, ali za manipulaciju je najbolje iz sql.Date u LocalDate
                all.add(m);
            }
        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return all;
    }

    public ArrayList<Manifestation> getFilteredManifestations(String name, LocalDate beginning, LocalDate end) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return null;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        String sql = "select * from manifestations where ";
        if (!name.isEmpty()) {
            sql += " name LIKE ? and ";
        }
        if (beginning != null) {
            sql += " date_to > ? and ";
        }
        if (end != null) {
            sql += " date_from < ? and ";
        }
        sql += " 1=1";
        try (PreparedStatement ps = con.prepareStatement(sql)) {
            int i = 1;
            if (!name.isEmpty()) {
                ps.setString(i, "%" + name + "%");
                i++;
            }
            if (beginning != null) {
                ps.setDate(i, java.sql.Date.valueOf(beginning));
                i++;
            }
            if (end != null) {
                ps.setDate(i, java.sql.Date.valueOf(end));
                i++;
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Manifestation m = new Manifestation();
                m.setId(rs.getInt("id"));
                m.setName(rs.getString("name"));
                m.setType(rs.getString("type"));
                m.setStatus(rs.getString("status"));
                m.setOrganizer(rs.getString("organizer"));

                // datum se cuva kao java.sql.Date, pa se kao takav i cita,
                // mada moze da se cita (i ubacuje) i kao string u yyyy-MM-dd formatu, pa da se onda parsira po potrebi
                java.sql.Date start = rs.getDate("date_from");
                m.setDateFrom(start.toLocalDate());
                // ili u jednoj naredbi
                m.setDateTo(rs.getDate("date_to").toLocalDate());
                // a moze i kao string da se procita u string ili java.util.Date promenljivu
                m.setDateFromString(rs.getString("date_from"));
                m.setDateToString(rs.getString("date_to"));
                // ili iz stringa u LocalDate
                m.setDateFrom(LocalDate.parse(rs.getString("date_from")));
                m.setDateTo(LocalDate.parse(rs.getString("date_to")));
                // a moze i iz java.sql.Date u java.util.Date
                // pomocu java.util.Date(sqlDate.getTime())

                // kako god je najlakse, ali za manipulaciju je najbolje iz sql.Date u LocalDate
                all.add(m);
            }
        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return all;
    }

    public ArrayList<Manifestation> getManifestationsByUser(String org) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return null;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        try (PreparedStatement ps = con.prepareStatement("select * from manifestations where organizer=?")) {
            ps.setString(1, org);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Manifestation m = new Manifestation();
                m.setId(rs.getInt("id"));
                m.setName(rs.getString("name"));
                m.setType(rs.getString("type"));
                m.setStatus(rs.getString("status"));
                m.setOrganizer(rs.getString("organizer"));

                // datum se cuva kao java.sql.Date, pa se kao takav i cita,
                // mada moze da se cita (i ubacuje) i kao string u yyyy-MM-dd formatu, pa da se onda parsira po potrebi
                java.sql.Date start = rs.getDate("date_from");
                m.setDateFrom(start.toLocalDate());
                // ili u jednoj naredbi
                m.setDateTo(rs.getDate("date_to").toLocalDate());
                // a moze i kao string da se procita u string ili java.util.Date promenljivu
                m.setDateFromString(rs.getString("date_from"));
                m.setDateToString(rs.getString("date_to"));
                // ili iz stringa u LocalDate
                m.setDateFrom(LocalDate.parse(rs.getString("date_from")));
                m.setDateTo(LocalDate.parse(rs.getString("date_to")));
                // a moze i iz java.sql.Date u java.util.Date
                // pomocu java.util.Date(sqlDate.getTime())

                // kako god je najlakse, ali za manipulaciju je najbolje iz sql.Date u LocalDate
                all.add(m);
            }
        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return all;
    }

    public boolean changeManifeststionStatus(int id, String newStatus) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return false;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        try (PreparedStatement ps = con.prepareStatement("update manifestations set status=? where id=?")) {
            ps.setString(1, newStatus);
            ps.setInt(2, id);

            return ps.executeUpdate() != 0;

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        } finally {
            DB.getInstance().putConnection(con);
        }
    }

    public boolean insertManifestation(Manifestation m) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return false;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        try (PreparedStatement ps = con.prepareStatement("insert into manifestations (name,date_from,date_to,type,status,organizer) values(?,?,?,?,?,?)")) {
            ps.setString(1, m.getName());
            ps.setDate(2, java.sql.Date.valueOf(m.getDateFrom()));
            ps.setDate(3, java.sql.Date.valueOf(m.getDateTo()));
            ps.setString(4, m.getType());
            ps.setString(5, m.getStatus());
            ps.setString(6, m.getOrganizer());

            return ps.executeUpdate() != 0;

        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        } finally {
            DB.getInstance().putConnection(con);
        }
    }

    public ArrayList<Manifestation> getNewManifestations() {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** Neuspesna konekcija na bazu podataka! ***");
            return null;
        }
        ArrayList<Manifestation> all = new ArrayList<>();
        try (PreparedStatement ps = con.prepareStatement("select * from manifestations where status=?")) {
            ps.setString(1, "nova");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Manifestation m = new Manifestation();
                m.setId(rs.getInt("id"));
                m.setName(rs.getString("name"));
                m.setType(rs.getString("type"));
                m.setStatus(rs.getString("status"));
                m.setOrganizer(rs.getString("organizer"));

                // datum se cuva kao java.sql.Date, pa se kao takav i cita,
                // mada moze da se cita (i ubacuje) i kao string u yyyy-MM-dd formatu, pa da se onda parsira po potrebi
                java.sql.Date start = rs.getDate("date_from");
                m.setDateFrom(start.toLocalDate());
                // ili u jednoj naredbi
                m.setDateTo(rs.getDate("date_to").toLocalDate());
                // a moze i kao string da se procita u string ili java.util.Date promenljivu
                m.setDateFromString(rs.getString("date_from"));
                m.setDateToString(rs.getString("date_to"));
                // ili iz stringa u LocalDate
                m.setDateFrom(LocalDate.parse(rs.getString("date_from")));
                m.setDateTo(LocalDate.parse(rs.getString("date_to")));
                // a moze i iz java.sql.Date u java.util.Date
                // pomocu java.util.Date(sqlDate.getTime())

                // kako god je najlakse, ali za manipulaciju je najbolje iz sql.Date u LocalDate
                all.add(m);
            }
        } catch (SQLException ex) {
            Logger.getLogger(UserDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return all;
    }

}
