package managed_beans;

import entities.Manifestation;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.dao.ManifestationDAO;

@Named(value = "searchMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class SearchManagedBean {

    private String name;
    private Date dateFrom; // citanje iz forme pomocu f:convertDateTime *mora* da se cuva u java.util.Date (ili String)
    private Date dateTo;
    private ArrayList<Manifestation> manifestations = new ArrayList<>();

    private String message;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDateFrom() {
        return dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public ArrayList<Manifestation> getManifestations() {
        return manifestations;
    }

    public String getMessage() {
        return message;
    }

    public void search() {

        ManifestationDAO mdao = new ManifestationDAO();

        // moze se raditi i sa java.util.Date, ali LocalDate ima mnogo metoda koje olaksavaju rad
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        LocalDate beginning = null, end = null;
        if (dateFrom != null) {
            beginning = LocalDate.parse(sdf.format(dateFrom));
        }
        if (dateTo != null) {
        }
        if (beginning != null && end != null && beginning.isAfter(end)) {
            message = "Datum pocetka ne sme biti pre datuma kraja!";
            return;
        }
        manifestations = mdao.getFilteredManifestations(name, beginning, end);
    }
}
