package managed_beans;

import entities.Manifestation;
import entities.User;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.SessionUtils;
import util.dao.ManifestationDAO;

@Named(value = "orgMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class OrganizatorManagedBean {

    private ArrayList<Manifestation> allMine = new ArrayList<>();
    private String name;
    private Date dateFrom; // citanje iz forme pomocu f:convertDateTime *mora* da se cuva u java.util.Date (ili String)
    private Date dateTo;
    private String type;

    public ArrayList<Manifestation> getAllMine() {
        return allMine;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDateFrom() {
        return dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @PostConstruct
    public void getEvents() {
        ManifestationDAO mdao = new ManifestationDAO();
        String loggedIn = ((User) SessionUtils.getSession().getAttribute("user")).getUsername();
        allMine = mdao.getManifestationsByUser(loggedIn);
    }

    public void unesi() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String loggedIn = ((User) SessionUtils.getSession().getAttribute("user")).getUsername();

        Manifestation m = new Manifestation();
        m.setName(name);
        m.setDateFrom(LocalDate.parse(sdf.format(dateFrom)));
        m.setDateTo(LocalDate.parse(sdf.format(dateTo)));
        m.setOrganizer(loggedIn);
        m.setType(type);
        m.setStatus("nova");
        ManifestationDAO mdao = new ManifestationDAO();
        if (!mdao.insertManifestation(m)) {
            System.err.println("Something was wrong while inserting...");
            return;
        }
        // da bi se prikazala i nova manifestacija, dohvaticemo ponovo sve
        // rucno bismo morali prvo da nadjemo maksimum id-a, da bismo i njega ubacili u objekat
        allMine = mdao.getManifestationsByUser(loggedIn);
        name = "";
        dateFrom = null;
        dateTo = null;
    }

    public void otkazi(int id) {
        ManifestationDAO mdao = new ManifestationDAO();
        boolean successs = mdao.changeManifeststionStatus(id, "otkazana");
        if (successs) {
            // mogu se ponovo dohvatiti iz baze manifestacije
            // a mozemo i za ovu jednu "rucno" da izmenimo
            for (Manifestation m : allMine) {
                if (m.getId() == id) {
                    m.setStatus("otkazana");
                    return;
                }
            }
        }
    }

}
