package managed_beans;

import entities.User;
import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.SessionUtils;
import util.dao.UserDAO;

@Named(value = "loginMB")
@SessionScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class LoginManagedBean implements Serializable {

    private String username;
    private String password;

    private String message;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMessage() {
        return message;
    }

    public String login() {
        UserDAO userDAO = new UserDAO();
        User user = userDAO.login(username, password);
        if (user == null) {
            message = "Greska u konekciji ka bazi";
        } else if (user.getUsername() == null) {
            message = "Korisnik ne postoji u bazi";
            username = "";
            password = "";
        } else if (user.getPassword() == null) {
            message = "Pogresna lozinka";
            password = "";
        } else {
            // message = "All good!";
            message = "";
            SessionUtils.getSession().setAttribute("user", user);
            if (user.isAdmin()) {
                return "administrator";
            } else {
                return "organizator";
            }
        }
        return "";
    }

    public String logout() {
        SessionUtils.getSession().invalidate();
        username = "";
        password = "";
        return "index";
    }
}
