package managed_beans;

import entities.Manifestation;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.dao.ManifestationDAO;

@Named(value = "adminMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class AdminManagedBean {

    private ArrayList<Manifestation> allNew = new ArrayList<>();

    public ArrayList<Manifestation> getAllNew() {
        return allNew;
    }

    @PostConstruct
    public void getEvents() {
        ManifestationDAO mdao = new ManifestationDAO();
        allNew = mdao.getNewManifestations();
    }

    public void approve(int id) {
        ManifestationDAO mdao = new ManifestationDAO();
        boolean successs = mdao.changeManifeststionStatus(id, "odobrena");
        if (successs) {
            // mogu se ponovo dohvatiti iz baze manifestacije
            // a mozemo i za ovu jednu "rucno" da izmenimo
            for (Manifestation m : allNew) {
                if (m.getId() == id) {
                    allNew.remove(m);
                    return;
                }
            }
        }
    }

    public void disapprove(int id) {
        ManifestationDAO mdao = new ManifestationDAO();
        boolean successs = mdao.changeManifeststionStatus(id, "odbijena");
        if (successs) {
            // mogu se ponovo dohvatiti iz baze manifestacije
            // a mozemo i za ovu jednu "rucno" da izmenimo
            for (Manifestation m : allNew) {
                if (m.getId() == id) {
                    allNew.remove(m);
                    return;
                }
            }
        }
    }
}
