# PowerShell: python generate.py <PATH> <ARRAY_LENGTH> <KEYS_LENGTH>
# Bash: python generate.py <PATH> <ARRAY_LENGTH> <KEYS_LENGTH>

# first command line argument is path to the output file
# second command line argument is array length
# third command line argument is keys length

import sys
import random

argv_length = len ( sys.argv )

path         = sys.argv[1] if ( argv_length >= 2 ) else "array_and_keys.txt"
array_length = int ( sys.argv[2] ) if ( argv_length >= 3 ) else 100
keys_length  = int ( sys.argv[3] ) if ( argv_length >= 4 ) else 100

array = [
    str ( i )
    for i in range ( array_length )
]

keys = [
    str ( random.randint ( 0, array_length ) )
    for i in range ( keys_length )
]

with open ( path, "w", encoding = "ascii" ) as file:
    file.write ( str ( array_length ) + "\n" )
    file.write ( " ".join ( array ) + "\n" )
    file.write ( str ( keys_length ) + "\n" )
    file.write ( " ".join ( keys ) )
