#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <time.h>

void min_max_v0 ( int *array, int length, int *min, int *max ) {
    int local_min = INT_MAX;
    int local_max = INT_MIN;
    
    for ( int i = 0; i < length; ++i ){
        if ( array[i] < local_min ) {
            local_min = array[i];
        }
    }
    
    for ( int i = 0; i < length; ++i ){
        if ( array[i] > local_max ) {
            local_max = array[i];
        }
    }
    
    *min = local_min;
    *max = local_max;
}

void min_max_v1 ( int *array, int length, int *min, int *max ) {
    int local_min = INT_MAX;
    int local_max = INT_MIN;
    
    for ( int i = 0; i < length; ++i ){
        if ( array[i] < local_min ) {
            local_min = array[i];
        }
        if ( array[i] > local_max ) {
            local_max = array[i];
        }
    }
    
    *min = local_min;
    *max = local_max;
}

int main ( int argc, char **argv ) {
    int type       = atoi ( argv[1] );
    int iterations = atoi ( argv[2] );
    
    FILE *input = fopen ( argv[3], "r" );
    if ( input == NULL ) {
        perror ( "Unable to open file!" );
        return 1;
    }
    
    int length = 0;
    fscanf ( input, "%d", &length );
    
    int *array = calloc ( length, sizeof ( int ) );
    for ( int i = 0; i < length; ++i ) {
        fscanf ( input, "%d", &array[i] );
    }
    
    int min = 0;
    int max = 0;
    
    clock_t start = clock ( );
    for ( int i = 0; i < iterations; ++i ) {
        switch ( type ) {
            case 0: {
                min_max_v0 ( array, length, &min, &max );
                break;
            }
            case 1: {
                min_max_v1 ( array, length, &min, &max );
                break;
            }
        }
    }
    clock_t end = clock ( );
    
    double elapsed_in_ms = ( end - start ) * 1. / CLOCKS_PER_SEC * 1000;
    
    printf ( "MIN = %d, MAX = %d\n", min, max );
    printf ( "ELAPSED (ms) = %lf\n", elapsed_in_ms );
    
    free ( array );
    fclose ( input );
    return  0;
}