# PowerShell: python generate.py <PATH> <ROWS> <COLUMNS> <MIN> <MAX>
# Bash: python generate.py <PATH> <ROWS> <COLUMNS> <MIN> <MAX>

# first command line argument is the number of path to the output file
# second command line argument is the number of rows
# third command line argument is the number of columns
# fourth command line argument is the minimal value in the array
# fifth command line argument is the maximal value in the array

import sys
import random

argv_length = len ( sys.argv )

path    = sys.argv[1] if ( argv_length >= 2 ) else "matrix.txt"
rows    = int ( sys.argv[2] ) if ( argv_length >= 3 ) else 100
columns = int ( sys.argv[3] ) if ( argv_length >= 4 ) else 100
min     = int ( sys.argv[4] ) if ( argv_length >= 5 ) else 0
max     = int ( sys.argv[5] ) if ( argv_length >= 6 ) else 10

array = [
    " ".join ( str ( random.randint ( min, max ) ) for i in range ( rows ) )
    for j in range ( columns )
]

with open ( path, "w", encoding = "ascii" ) as file:
    file.write ( str ( rows ) + " " + str ( columns ) + "\n" )
    file.write ( "\n".join ( array ) )