#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int dot_product_v0 ( int *a, int *b, int length ) {
    int dot_product = 0;
    
    for ( int i = 0; i < length; ++i ){
        dot_product += a[i] * b[i];
    }
    
    return dot_product;
}

int dot_product_v1 ( int *a, int *b, int length ) {
    int dot_product = 0;
    
    int i = 0;
    
    switch ( length & 7 ) {
        case 7: dot_product += a[i] * b[i]; i++;
        case 6: dot_product += a[i] * b[i]; i++;
        case 5: dot_product += a[i] * b[i]; i++;
        case 4: dot_product += a[i] * b[i]; i++;
        case 3: dot_product += a[i] * b[i]; i++;
        case 2: dot_product += a[i] * b[i]; i++;
        case 1: dot_product += a[i] * b[i]; i++;
    }
    
    for ( ; i < length; i += 8 ){
        dot_product += a[i + 0] * b[i + 0];
        dot_product += a[i + 1] * b[i + 1];
        dot_product += a[i + 2] * b[i + 2];
        dot_product += a[i + 3] * b[i + 3];
        dot_product += a[i + 4] * b[i + 4];
        dot_product += a[i + 5] * b[i + 5];
        dot_product += a[i + 6] * b[i + 6];
        dot_product += a[i + 7] * b[i + 7];
    }
    
    return dot_product;
}

int main ( int argc, char **argv ) {
    int type       = atoi ( argv[1] );
    int iterations = atoi ( argv[2] );
    
    FILE *input = fopen ( argv[3], "r" );
    if ( input == NULL  ) {
        perror ( "Unable to open file!" );
        return 1;
    }
    
    int length = 0;
    fscanf ( input, "%d", &length );
    
    int *a = calloc ( length, sizeof ( int ) );
    int *b = calloc ( length, sizeof ( int ) );
    
    if ( a == NULL || b == NULL ) {
        exit ( 1 );
    }
    
    for ( int i = 0; i < length; ++i ) {
        fscanf ( input, "%d", &a[i] );
    }
    for ( int i = 0; i < length; ++i ) {
        fscanf ( input, "%d", &b[i] );
    }
    
    clock_t start = clock ( );
    int dot_product = 0;
    for ( int i = 0; i < iterations; ++i ) {
        switch ( type ) {
            case 0: {
                dot_product = dot_product_v0 ( a, b, length );
                break;
            }
            case 1: {
                dot_product = dot_product_v1 ( a, b, length );
                break;
            }
        }
    }
    clock_t end = clock ( );
    
    double elapsed_in_ms = ( end - start ) * 1. / CLOCKS_PER_SEC * 1000;
    
    printf ( "DOT_PRODUCT =  %d\n", dot_product );
    printf ( "ELAPSED (ms) = %lf\n", elapsed_in_ms );
    
    free ( a );
    free ( b );
    fclose ( input );
    return  0;
}