
  import java.io.*;
  import java.util.*;
  import java.awt.*;
  /**                           class BFSURL computes Jaccard's scores*/
  class BFSURL {
    private String httpName;                      //documents' http name
    public int[] indeksi;                 //documents' keyword frequency
    public Vector linkovi = new Vector();             //documents' links
  //--------------------------------------------------------------------
    public BFSURL(String url) { 
      httpName=url;                                 //BFSURL constructor
    }
  //--------------------------------------------------------------------
    public String getHttpName() { 
      return httpName;                     //returns documents'http name
    }
  //--------------------------------------------------------------------
    public String getFileName() {         //returns documents' file name
      return httpName.replace('/',File.separatorChar); 
    }
  //--------------------------------------------------------------------
    public void initIndeksi() {
      indeksi = new int[BFS.l];   //init size of keyword frequency array
      for (int i=0; i<BFS.l; i++) indeksi[i]=0;
    }
  //--------------------------------------------------------------------
    public double js() {
      double jsL=0.0; //computes jaccard's score for one possible output
      double jsI=0.0;
      for (int i=0; i<BFS.n; i++) {
        jsL+=jsLinks(BFS.ulazN[i].linkovi)/BFS.n;
        jsI+=jsIndex(BFS.ulazN[i].indeksi)/BFS.n;
      }
      if (BFS.coms) {
        BFS.frame.pisi("--> jsLinks="+jsL);
        BFS.frame.pisi("--> jsIndex="+jsI);
        BFS.frame.pisi("--> js     ="+(jsL+jsI)/2);
        BFS.frame.pisi("=========================================");
      }
      return (jsL+jsI)/2;
    }
  //--------------------------------------------------------------------
    private double jsLinks(Vector uLinkovi) {
      int nK=linkovi.size();       //computes jaccard's score from links
      int nU=uLinkovi.size();
      double p=0.0;
      String s;
      if (BFS.coms) {
          BFS.frame.pisi("  -> nk="+nK);
          BFS.frame.pisi("  -> nu="+nU);
      }
      if (nK==0 || nU==0) return 0;
      if (nK>nU) {
        for (int i=0; i<nU; i++) {
          s=(String)uLinkovi.elementAt(i);
          if (linkovi.contains(s)) p++;
        }
      } 
      else {
        for (int i=0; i<nK; i++) {
          s=(String)linkovi.elementAt(i);
          if (uLinkovi.contains(s)) p++;
        }
      }
      if (BFS.coms) {
         BFS.frame.pisi("  -> p="+p);
          BFS.frame.pisi("  --------> p/(nK+nU-p)="+p/(nK+nU-p));
      }
      return p/(nK+nU-p);
    }
  //--------------------------------------------------------------------
    private double jsIndex(int[] uIndeksi) {
      double x2=0.0;            //computes jaccard's score from keywords
      double y2=0.0; 
      double xy=0.0;
      for (int i=0; i<BFS.l; i++) { 
        x2+=BFS.a2[i]*indeksi[i]*indeksi[i];
        xy+=BFS.a2[i]*indeksi[i]*uIndeksi[i];
        y2+=BFS.a2[i]*uIndeksi[i]*uIndeksi[i];      
      }
      if (BFS.coms) {
          BFS.frame.pisi("  -> x2="+x2);
          BFS.frame.pisi("  -> xy="+xy);
          BFS.frame.pisi("  -> y2="+y2);
      }
      if (x2+xy+y2 == 0) return 0;
      else { 
        if (BFS.coms) {
           BFS.frame.pisi("  --------> 3*xy/(x2+xy+y2)=");
            BFS.frame.pisi(" "+3*xy/(x2+xy+y2));
        }
        return 3*xy/(x2+xy+y2);
      }
    }
  }
