import java.net.*;
import java.io.*;
import java.util.*;

/**MyURL is extended URL                  
   Instances of MyURL are queued in Queue */
class MyURL{
  //queue where MyURL waits to be fetched by a thread
  static public Queue queue;
  private URL url;
  //depth to which links from starting file will be followed
  private int depth;
  //UNIX-like name of file relative to position of MyURL.class
  private String httpName;
  //host OS dependent name of file with path relative to position of MyURL.class
  private String fileName;  
  //fileLevel is ???????????
  private int fileLevel;    
  //base is string "[../]server/basedir"; presence of "../" depends on a BASE tag
  private String base;
//instance of the HttpParser parses files while fetching them from Web
  private HttpParser hp;
//instance of the FileParser parses files which have been fetched before
  private FileParser fp;

  public URL getURL(){return url;}
  public int getDepth(){return depth;}
  public String getFileName(){return fileName;}
  public String getHttpName(){return httpName;}
  public int getFileLevel(){return fileLevel;}
  public String getBase(){return base;}
  public void setBase(String b){base=b;}

  public MyURL(){}
  public MyURL(String u,int depth) throws MalformedURLException{
   url=new URL(u);
   httpName=url.getHost()+url.getFile();
   fileName=httpName.replace('/',File.separatorChar);

   //only HTML, HTM, and ASP files have links;
   //  other files have to be fetched even if they are at depth 0
   if(!(httpName.toLowerCase().endsWith("html")||
        httpName.toLowerCase().endsWith("htm")||
        httpName.toLowerCase().endsWith("asp")))
      this.depth=1;
   else this.depth=depth;   

   //setting fileLevel
   int next;int pos=0;
   while((next=httpName.indexOf('/',pos))!=-1){
          fileLevel++;pos=next+1;
   }

   //by default, base is the directory path on the Web server 
   base=httpName.substring(0,httpName.lastIndexOf("/")+1);
   fp=new FileParser(this,queue); 
   hp=new HttpParser(this,queue); 
  }

  public void fileParsing(DataInputStream dis){
    fp.parsing(dis);
  }

  public void httpParsing(DataInputStream dis){
    hp.parsing(dis);
  }

  /**starting point of the program
     args[0]=URL
     args[1]=depth
     args[2]=number of Threads
     args[3]=switch for enabling or disabling picture(s) loading */
  static public void main(String[] args) throws IOException{
   Linker[] linker;MyURL root;
   //PrintStream ps=new PrintStream(new FileOutputStream("greske.err"));
   //System.setErr(ps);
   //  Properties sysp = System.getProperties();
   //  sysp.put("http.proxyHost", "proxy.rcub.bg.ac.yu");
   //  sysp.put("http.proxyPort", "8080");
 
  // now tell the JDK http code about the new settings
     // sun.net.www.http.HttpClient.resetProperties();    
    // System.setProperties(sysp);
   boolean depthSet=false;int depth=2;
   boolean picSet=false;boolean pics=true;
   boolean linkSet=false;int nOfLinkers=3;
   if(args.length==0||args.length>4){printHelp();return;}

   try{
   //parsing of the command line
    for(int i=1;i<args.length;i++){

     //setting the depth
     if(args[i].startsWith("-d")){
      if(!depthSet){
       depth=Integer.parseInt(args[i].substring(2));
      if(depth<=0){printHelp();return;}
       depthSet=true;
      }
      else {printHelp();return;}
     }

     //setting the number of the threads
     else if(args[i].startsWith("-t")){
      if(!linkSet){
       nOfLinkers=Integer.parseInt(args[i].substring(2));
      if(nOfLinkers<=0){printHelp();return;}
       linkSet=true;
      }
      else {printHelp();return;}
     }

     //enabling or disabling picture(s) loading
     else if(args[i].startsWith("-p")){
      if(!picSet){
       if(args[i].substring(2).startsWith("y"))
         pics=true;
       else if(args[i].substring(2).startsWith("n"))
         pics=false;
       else{printHelp();return;}
       picSet=true;
      }
      else {printHelp();return;}
     }
     else {printHelp();return;} 
    }
   }catch(Exception e){printHelp();return;}
  
   try{
    if(!args[0].toLowerCase().startsWith("http://"))
       args[0]="http://"+args[0];
    if(args[0].indexOf('/',7)==-1)
       args[0]=args[0]+"/index.html";
    if(args[0].endsWith("/"))
       args[0]=args[0]+"index.html";
    if(args[0].lastIndexOf(".")<args[0].lastIndexOf("/"))
       args[0]=args[0]+"/index.html";
    queue=new Queue(nOfLinkers,pics);
    linker=new Linker[nOfLinkers];
    for (int i=0;i<linker.length;i++){
        linker[i]=new Linker(String.valueOf(i),queue);
    }
    root=new MyURL(args[0],depth);
    queue.putURL(root);  //the starting URL is enqueued
    for (int i=0;i<linker.length;i++) linker[i].start();

    //when all threads are waiting, work is done
    boolean over=false;
    while(!over){
     Thread.sleep(5000); //it is still to be determined which value is the most appropriate
     over=true;
     for (int i=0;i<linker.length;i++)
      over=(queue.table.elementAt(i)==null)&&over; 
    }
    for(int i=0;i<linker.length;i++)linker[i].stop();
    return;
   }catch(MalformedURLException moe){
         System.out.println("Invalid URL");
         return; 
   }
   catch(InterruptedException ie){}
  } 

  /**printing help if an error is found in command line*/
  static private void printHelp(){
   String line;
   try{
    FileInputStream fis=new FileInputStream("Read.me");
    DataInputStream dis=new DataInputStream(fis);
    System.out.println();
    while((line=dis.readLine())!=null)
     System.out.println(line);
   }catch(FileNotFoundException fnfe){return;}
    catch(IOException ioe){}
  }

}
