import java.io.*;
import java.net.*;

/* klasa Linker dohvata MyURL izdvaja iz njega URL, otvara konekciju i
   formira novi fajl, a zatim predaje parseru InputStream i OutputStream*/
class Linker extends Thread{

 public Linker(String name,Queue queue){
     super(name);
     this.queue=queue;
 }
 private Queue queue;

 public void run(){
  MyURL u;
  DataInputStream dis;
  char sep=File.separatorChar;
  int intName=Integer.parseInt(getName());
  while(true){
   u=queue.getURL(intName); //uzima url iz reda
   if (u.getURL().getProtocol().startsWith("http")){  
     //konekcija
     try{
      dis=new DataInputStream(u.getURL().openStream());
//DEBUG
    System.out.println(getName()+" Fetching "+u.getURL().toString());
//END DEBUG
      //objekat tipa File sluzi samo za kreiranje direktorija
      //jer FileOutputStream ne moze da kreira direktorij
      File dat=new File(u.getFileName());
      if(u.getFileName().lastIndexOf(sep)!=-1){
       File path=new File
            (u.getFileName().substring(0,u.getFileName().lastIndexOf(sep)));
       path.mkdirs();
      }
      //ako treba napraviti poddirektorije koristi se novi objekat klase File
      //jer bi dat.mkdirs() napravio i direktorij sa imenom fajla
      //pozivanje funkcije obrada koja treba da throws IOException
      if(!(u.getHttpName().toLowerCase().endsWith("htm")||
           u.getHttpName().toLowerCase().endsWith("html")||
           u.getHttpName().toLowerCase().endsWith("asp"))){
        FileOutputStream fos=new FileOutputStream(u.getFileName());
        int c;
        while((c=dis.read())!=-1)fos.write(c);
        fos.close();  
        continue;
      }
      u.httpParsing(dis);
      dis.close();
     }catch(IOException ioe){//ovde treba napraviti nesto slozenije -)
            //DEBUG
              System.out.println(getName()+" Http Error: "+u.getHttpName());
            //END DEBUG
              continue;
      }
      catch(Exception e){
            System.out.println(getName()+" Unexpected error");
      }
   }
   else{// ako pocinje sa "file:" mora biti htm, asp ili html, jer ga
        // Queue ne bi stavio u red  
     try{dis=new DataInputStream(new FileInputStream(u.getFileName()));
      System.out.println(getName()+" Parsing "+u.getURL().toString());
      u.fileParsing(dis);//kad se obradjuje fajl sa diska    
      dis.close();
     }catch(Exception e){
        System.out.println(getName()+" I/0 Error: "+u.getFileName());
        continue;}
   }
  }
 }

}