#if !defined(AFX_BOARDSOCKET_H__B31A2BC3_92AD_11D2_9937_0080AD3046FD__INCLUDED_)
#define AFX_BOARDSOCKET_H__B31A2BC3_92AD_11D2_9937_0080AD3046FD__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// BoardSocket.h : header file
//

#include <afxtempl.h>
#include <afxsock.h>
#include <afx.h>

#define MaxListCount 20
#define MaxPacketSize 500

#define BOARDRETRYTIMERID 100
#define BOARDTIMEOUTTIMERID 101
#define BOARDTIMEOUT 1000
#define BOARDRETRYTIMEOUT 5000
/////////////////////////////////////////////////////////////////////////////
// CBoardSocket command target
enum notifyBoardAction {nbaVisitPage,
			nbaSavePage,
			nbaSaveThisImage,
			nbaPrintPage,
			nbaFollowLink,
			nbaClipboardCopy,
			nbaCopyLink,
			nbaCopyImageLocation,
			nbaAddBookmark,
			nbaSaveThisLink, 
			nbaCustomRanking
};

enum BOARDSTATE
{
	bsFoo = 1,
	bsInitializing = 2,
	bsInitialized = 4,
	bsCreated = 8,
	bsWaiting = 16
};

typedef struct _BoardActionData
{
	CString url;
	WORD actionCode;
	CString link;
	int customRank;
	// demographic data or what?
} BoardActionData;


VOID CALLBACK BoardTimerProc( HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime); 

class CBoardSocket : public CAsyncSocket
{
// Attributes
public:
	CTypedPtrList<CPtrList, BoardActionData*> m_baDataList;
	int m_iListByteCount;
	CString m_strServerAdr;
	int m_iPort;
	int m_state;
// Operations
public:
	CBoardSocket();
	virtual ~CBoardSocket();

	void StartConnect();
	void Initialize();
	void OnClose(int nErrorCode);
	void NewData(CString url, int actionCode, void* extraData = NULL);
	void FlushBuffer();
	void StartTimeoutTimer();
	void StartRetryTimer();
 
// Overrides
public:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBoardSocket)
	public:
	virtual void OnConnect(int nErrorCode);
	virtual void OnAccept(int nErrorCode);
	//}}AFX_VIRTUAL

	// Generated message map functions
	//{{AFX_MSG(CBoardSocket)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

// Implementation
protected:

};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BOARDSOCKET_H__B31A2BC3_92AD_11D2_9937_0080AD3046FD__INCLUDED_)
