	#!/usr/bin/perl
	#
	# seek for delays between accesses
	# count all repeated accesses, find 10% limits
	#
	
	#define constants
		
	$_Timestamp=0; 	$_Elapsed_Time=1;	$_HTTP_code=2;  
	$_Size=3; 	$_Method=4; 		$_URL=5;
	$_Exp_Date=6;	$_Next_Acc=7; 		$_Cacheable=8;
	$elapsed_time = 0;	#simulation time

   	#open log file
	open(LOG, ">report_delays.txt") || die "$0: report_delays.txt will not open.";
	seek(LOG, 0,2);

	#process all files in directory with extension ".new"
		print "\nColecting data...\n";
		open(TRACES, "+<sort_rez_delays.txt") || die "$file will not open.";
		print "\nOpened: ". $file. "\n";
		seek(TRACES, 0,2); $file_size = tell(TRACES); seek(TRACES, 0,0); 
		$max=0; $count=0;
		
		$pos = tell(TRACES);
		$start_time = time();
		while(<TRACES>) { # takes data from $file
			print "\rdone: ".(tell(TRACES)/$file_size)." of 1     ";
			#if((tell(TRACES)/$file_size)>0.0025){last;}
			@list = split(" ", $_);
			$count += $list[1];
			if($max<$list[0]){$max=$list[0]};
		}
		$end_time = time();
		$elapsed_time += ($end_time-$start_time);


	print "\nMax: ". $max;
	print "\nCount: ". $count;
	print LOG "\nMax: ". $max;
	print LOG "\nCount: ". $count;
	print "\nPassed: ". $elapsed_time." seconds.";

	print "\nSplitting...\n";
		seek(TRACES, 0,2); $file_size = tell(TRACES); seek(TRACES, 0,0); 
		$ccount=0; $step=0.1;
		
		$pos = tell(TRACES);
		$start_time = time();
		while(<TRACES>) { # takes data from $file
			print "\rdone: ".(tell(TRACES)/$file_size)." of 1     ";
			#if((tell(TRACES)/$file_size)>0.0025){last;}
			@list = split(" ", $_);
			$ccount += $list[1];
			if($ccount>$step*$count){
			  print "\n$step: ". $list[0];
			  print LOG "\n$step: ". $list[0];
			  $step+=0.1;
			};
		}
		$end_time = time();
		$elapsed_time += ($end_time-$start_time);

	print "\nPassed: ". $elapsed_time." seconds.\n";
	
	close(TRACES);
	print "\nClosed: ". $s."\n";


## end ##


#############################################
# algorythms
#############################################


###########
# DELAYS  #
###########

	sub delays{
		my($del);
		$del = $list[$_Next_Acc] - $list[$_Timestamp];
		if($del>=0){
			$stat{$del}+=1;
		}
	}

############################################
#subroutine for dumping asoc array to file #
############################################

sub storeaa($$){
	my $a=shift(@_), $f=shift(@_), $key;

	open(DMP, "$f") || die "$0: will not open.";
	
		while (($key, $val) = each (%$a) ){
			print DMP $key." ".$val."\n";
			#print DMP $$a{$key}."\n";
		}

	close DMP;
}


sub sort_storeaa($$){
	my $hash=shift(@_), $f=shift(@_), $key;

	open(DMP, "$f") || die "$0: will not open.";
	
		foreach $key (sort {$a <=> $b} keys %$hash) {
			print DMP $key." ".$$hash{$key}."\n";
         }

	close DMP;
}

sub loadaa($$){
	my $a=shift(@_), $f=shift(@_), $key;

	open(DMP, "<$f") || die "$0: will not open.";
	
		while(<DMP>) { # takes data from $file
			@list = split(" ", $_);
			$$a{$list[0]}=$list[1];
		}

	close DMP;
}
