	#!/usr/bin/perl
	#
	# Record delays between accesses
	#
	
	#define constants
	$elapsed_time = 0;	#simulation time
	$_Timestamp=0; $_Secstamp=1 ;$_Elapsed_Time=2; $_Client_Address=3; 
	$_HTTP_code=4; $_Size=5; $_Method=6; $_URL=7; $_User_Ident=8, 
	$_Hierarchy=9; $_Type=10; $_Exp_Date=11; $_Next_Acc=12; 
	$_Cacheable=13;


	$size_all=0; $size_nr=0; 
	$acc_all=0; $acc_nr=0; 

	#process all files in directory with extension ".new"
	foreach $file (<*.new>) {
       	open(TRACES, "+<$file") || die "$file will not open.";
		print "\nOpened: ". $file. "\n";
		seek(TRACES, 0,2); $file_size = tell(TRACES); seek(TRACES, 0,0); 
		
		$start_time = time();
		while(<TRACES>) { # takes data from $file
			print "\rdone: ".(tell(TRACES)/$file_size)." of 1     ";
			#if((tell(TRACES)/$file_size)>0.01){last;}
			@list = split(" ", $_);
			if($list[$_Cacheable]){
				&process;
			}
		}
		$end_time = time();
		close(TRACES);
		$elapsed_time += ($end_time-$start_time);
    }
	print "\nSize_all=".$size_all." Size_nr=".$size_nr. "\n";
	print "\nSize_all=".$acc_all." Size_nr=".$acc_nr. "\n";
	
	print "\nStoring next accesses... ". "\n";
	&storeaa(\%count, ">rezultati_next_acc.txt");
	print "\nStoring no. of accesses... ". "\n";
	&calc_visited;
	&storeaa(\%count, ">rezultati_count_acc.txt");
	print "\nFinished in ".$elapsed_time. " secs\n";




#############################################
# algorythms
#############################################

##########################
# track accesses         #
##########################
	sub process{
		if(index($list[$_Next_Acc], ">") < 0){
			$pom = $list[$_Next_Acc]-$list[$_Timestamp];
			$count{$pom}++;
			$size_nr+=$list[$_Size];
			$acc_nr++;
		}
		else{$size_all+=$list[$_Size]; $acc_all++;}
		$visited{$list[$_URL]}++;
	}

	sub calc_visited{
		undef %count;
		foreach $key (keys %visited) {
			$pom=$visited{$key};
			undef $visited{$key};
			$count{$pom}++;

		}
	}

############################################
#subroutine for dumping asoc array to file #
############################################

sub storeaa($$){
	my $a=shift(@_), $f=shift(@_), $key;

	open(DMP, "$f") || die "$0: will not open.";
	
		foreach $key (sort keys %$a) {
			#print DMP $key." ".$$a{$key}."\n";
			print DMP $$a{$key}."\n";
		}

	close DMP;
}

sub loadaa($$){
	my $a=shift(@_), $f=shift(@_), $key;

	open(DMP, "<$f") || die "$0: will not open.";
	
		while(<DMP>) { # takes data from $file
			@list = split(" ", $_);
			$$a{$list[0]}=$list[1];
		}

	close DMP;
}
