	#!/usr/bin/perl
	#
	# FIFO algorythm
	#
	
	#define constants
	$all_free = 1600000000;		#cache size
	$fifo_free = $all_free;	#atp cache size
	$elapsed_time = 0;	#simulation time

   	#open log file
	open(LOG, "+<rezultati_fifo.txt") || die "$0: rezultati.txt will not open.";
	seek(LOG, 0,2);

	#process all files in directory with extension ".new"
	foreach $file (<*.new>) {
       	open(TRACES, "+<$file") || die "$file will not open.";
		print "\nOpened: ". $file. "\n";
		seek(TRACES, 0,2); $file_size = tell(TRACES); seek(TRACES, 0,0); 
		
		$pos = tell(TRACES);
		$prev_pos = tell(TRACES);
		$start_time = time();
		while(<TRACES>) { # takes data from $file
			print "\rdone: ".(tell(TRACES)/$file_size)." of 1     ";
			#if((tell(TRACES)/$file_size)>0.25){last;}
			@list = split(" ", $_);
			if($list[13]){
				&fifo;
			}
		}
		$end_time = time();
		close(TRACES);
		$elapsed_time += ($end_time-$start_time);
    }
	print "\nClosed: ". $s."\n";
	&std_stat;
	&log_stat;

## end ##


sub std_stat{
		print "Size = $all_free bytes, elapsed $elapsed_time seconds	atp refresh=$atp_refresh\n";
		if($fifo_access){print "FIFO     : Acc = $fifo_access, Hits = $fifo_hits (".($fifo_hits/$fifo_access*100)."%), Miss = $fifo_miss \n".
							   "		   WAcc = $fifo_waccess, WHits = $fifo_whits (".($fifo_whits/$fifo_waccess*100)."%), WMiss = $fifo_wmiss \n";}
}
sub log_stat{
		print LOG "Size = $all_free, elapsed $elapsed_time seconds	atp refresh=$atp_refresh\n";
		if($fifo_access){print LOG "FIFO     : Acc = $fifo_access, Hits = $fifo_hits (".($fifo_hits/$fifo_access*100)."%), Miss = $fifo_miss \n".
										"WAcc = $fifo_waccess, WHits = $fifo_whits (".($fifo_whits/$fifo_waccess*100)."%), WMiss = $fifo_wmiss \n";}
}
#############################################
# algorythms
#############################################


###########
# F I F O #
###########

	sub fifo{
		local($i);
		if($all_free*0.1 < $list[5]){
			$fifo_miss++;
			$fifo_wmiss += $list[5];
			$fifo_access++;
			$fifo_waccess+=$list[5];
			return 0;
		}elsif(defined $fifo_cache{$list[7]}){
			#found in the cache
			$fifo_hits++;
			$fifo_whits += $list[5];
		}else{
			#not found in the cache
			$fifo_miss++;
			$fifo_wmiss += $list[5];
			
			# if there is no free space in the cache...
			while($fifo_free < $list[5]){
				#...free some space
				$fifo_free += $fifo_cache{$fifo_sorted_access[0]};
				delete($fifo_cache{$fifo_sorted_access[0]});
				shift(@fifo_sorted_access);
			}
			
			#now there is free space in cache
			$fifo_free -= $list[5];	#reserve some space
			push(@fifo_sorted_access, $list[7]);	#add to the tail of the list
		}
		
		#update cache for all cases
		$fifo_cache{$list[7]} = $list[5];	#new last access time
		$fifo_access++;
		$fifo_waccess+=$list[5];
	}
