

//Klasa za pristup bazi turltable
import java.awt.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import java.net.*;
public class TBaza{
	private Connection tveza;
	private PreparedStatement ubaci;
	private PreparedStatement azuriraj;
	private PreparedStatement citaj;
	private PreparedStatement selektujTopike;
	private PreparedStatement proveriZapis;
	private PreparedStatement brisiTopic;
	private PreparedStatement brisiUrl;
	private PreparedStatement brisiCN;
	private PreparedStatement citajCN;
        static public  int CN;


		//TBaza konstruktor:pravi SQL upite za kasniju upotrebu
		public TBaza(String tbaza,String korisnik,String lozinka){
		try{
			Class.forName ("sun.jdbc.odbc.JdbcOdbcDriver");
				}catch(ClassNotFoundException g){System.exit(1);} 
					// Make the connection object.
				try{
				   tveza = DriverManager.getConnection(tbaza,korisnik,lozinka);
				}catch(SQLException e){
				   System.out.println("*** Neuspesno otvaranje baze ***");
				   System.exit(2);
				}
		try{
				   ubaci=tveza.prepareStatement("INSERT INTO turltable VALUES(?,?,?);");
				   azuriraj=tveza.prepareStatement("UPDATE turltable SET CN=CN+1 WHERE Topic=? AND URL=?;");
				   citaj=tveza.prepareStatement("SELECT URL FROM turltable WHERE Topic=? ORDER BY CN DESC;");
				   selektujTopike=tveza.prepareStatement("SELECT DISTINCT Topic FROM turltable;");
				   proveriZapis=tveza.prepareStatement("SELECT * FROM turltable WHERE Topic=? and URL=?;");
				   brisiTopic=tveza.prepareStatement("DELETE * FROM turltable WHERE Topic= ?;");
				   brisiUrl=tveza.prepareStatement("DELETE * FROM turltable WHERE Topic= ? and URL=?;");
				   brisiCN=tveza.prepareStatement("DELETE * FROM turltable WHERE Topic= ? and CN<=ALL(SELECT CN FROM turltable WHERE Topic=?);");
				   citajCN=tveza.prepareStatement("SELECT CN FROM turltable WHERE Topic=? AND URL=?;");
				}catch (SQLException e){
				  System.out.println("Neuspesna inicijalizacija upita");
			}
	}
		//Metod za citanje url-ova za zati topic
		public String[] citaj(String Topic) throws SQLException{
				int i=0;
				ResultSet rs;
				String ceoUrl;
				String[] rezultat= new String[500];
				citaj.setString(1,Topic);
				rs=citaj.executeQuery();
                                for (int b=0;b<MyPanel.temprate;b++){
				if (rs.next()){
						ceoUrl=rs.getString(1);
						rezultat[i++]=ceoUrl.substring(0,ceoUrl.indexOf("#http://"));
					}}	
				rs.close();
				return rezultat;
		}
		//Metod za brisanje svih zapisa sa zadatim topikom
		public void obrisi(String Topic)throws SQLException{
				if(!usluge.prazanString(Topic)){
					brisiTopic.setString(1,Topic);
					brisiTopic.executeUpdate();
				}
                                return ;	
		}
		//Metod za brisanje zapisa sa zadatim url-om i topikom
		public void obrisi(String Topic,String[] Url) throws SQLException{
				brisiUrl.setString(1,Topic);
				for(int i=0;i<Url.length;i++){
					Url[i]=new String(Url[i]+"#http://"+Url[i]+"#");
					brisiUrl.setString(2,Url[i]);
					brisiUrl.executeUpdate();
				}
                                return ;	
		}
		//Metod za brisanje URL-ova ca min CN (kod prepunjenja baze)
		public void obrisiCN(String Topic) throws SQLException{
				brisiCN.setString(1,Topic);
				brisiCN.setString(2,Topic);
				brisiCN.executeUpdate();
                                return ;
		}
		//Metod za ispitivanje da li postoji zapis
		private boolean postojiZapis(String Topic,String Url) throws SQLException{
				ResultSet rs;
				proveriZapis.setString(1,Topic);
				proveriZapis.setString(2,Url);
				rs=proveriZapis.executeQuery();
				boolean b= rs.next();
				rs.close();
				return b;
		}
		//Metod za selektovanje svih topika
		public String[] selektujTopike()throws SQLException{
				int i=0;
				String[] rezultat= new String[100];
				ResultSet rs;
				rs=selektujTopike.executeQuery();
				while(rs.next()){
					rezultat[i++]=rs.getString(1);}
				return rezultat;
		}
		//Metod za interaktivno kreiranje novog zapisa u bazi turltable
		public void ubaci(String[] Url) throws SQLException {
                        for(int j=0;j<MyPanel.temp1.length;j++){
			if(!usluge.prazanString(MyPanel.temp1[j])){
				//MyPanel.temp1[j]=new String(usluge.ocistiString(MyPanel.temp1[j]));
				ubaci.setString(1,MyPanel.temp1[j]);
				for(int i=0;i<Url.length;i++){
					if(!usluge.prazanString(Url[i])){
						Url[i]=new String(Url[i]+"#http://"+Url[i]+"#");
						ubaci.setString(2,Url[i]);
						if(!postojiZapis(MyPanel.temp1[j],Url[i])){
							CN=1;
							ubaci.setInt(3,CN);
							ubaci.execute();
						}
						else{
							azuriraj(MyPanel.temp1[j],Url[i]);
						}
					}	
				}	
			 }}
                         return ;
		}
                //Metod za interaktivno azuriranje zapisa u bazi turltable
		public void azuriraj(String Topic,String Url) throws SQLException {
			if(!usluge.prazanString(Topic)){
				azuriraj.setString(1,Topic);
				if(!usluge.prazanString(Url)){
					azuriraj.setString(2,Url);
					azuriraj.execute();
					}		
			}
                        return ;
		}		
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param Topic java.lang.String
 * @param Url java.lang.String
 */
   public void ubaci(String Topic,String Url,Label status) throws SQLException {
				if(!usluge.prazanString(Topic) & !usluge.prazanString(Url)){
					Url=new String(Url+"#http://"+Url+"#");
					Topic=new String(usluge.ocistiString(Topic));
					ubaci.setString(1,Topic);
					ubaci.setString(2,Url);
					CN=1;
					ubaci.setInt(3,CN);
					if(!postojiZapis(Topic,Url)) {
						ubaci.execute();
						status.setText("Updated 1 row in the Database");}
					else{
						status.setText("Url allready exists");
						}
				}
				else{
					status.setText("Uncorrect data-Updated 0 rows in the database");
				}
				return ;			
}
}