  import java.io.*;
  import java.util.*;
  import java.awt.*;
  /** class BFS has fields and methods for Best First Search algorithm*/
  class BFS {
    static public Vector ulaz = new Vector();          //input documents
    static public Vector kand = new Vector();         //possible outputs
    static public Hashtable kandJS = new Hashtable(); //option documents
    static public Hashtable izlaz = new Hashtable();  //output documents
    static public Vector nizKW = new Vector();                //keywords
    static public int n;                     //number of input documents
    static public int l;                            //number of keywords
    static public int nK;           //current number of possible outputs
    static public int maxKW;                    //maximum keyword length
    static public BFSURL[] ulazN;             //array of input documents
    static public BFSURL[] kandN;            //array of possible outputs
    static private int[] df;      //keyword frequency in input documents
    static private int[] w;                         //length of keywords
    static public double[] a2;       //array for BFSURL.jsIndex() method
    static public boolean coms = true;                 //enable comments
    static public String sep = "\t\n\r ,;.'`:!-+=?()";      //separators
    static public Flow frame;
  //--------------------------------------------------------------------
    static public void initFileParsing(String fajl) {
      try {                                  //load keywords from a file
        DataInputStream dis;
        dis = new DataInputStream(new FileInputStream(fajl));
        if (BFS.coms) {
         frame.pisi("KEYParsing "+fajl);
        }
	KeyParser.init();
        KeyParser.Fill(dis);
        KeyParser.arrange();
        KeyParser.purge();
        dis.close();
      }
      catch(Exception e) { frame.pisi("I/0 Error "); }
    }
  //--------------------------------------------------------------------
    static public void initUlazN() {
      n=ulaz.size();                //create an array of input documents
      ulazN = new BFSURL[n];
      for (int i=0; i<n; i++) 
        ulazN[i] = new BFSURL((String)ulaz.elementAt(i)); 
    }
  //--------------------------------------------------------------------
    static public void initKandN() {
      nK=kand.size();              //create an array of possible outputs
      kandN = new BFSURL[nK];
      for (int i=0; i<nK; i++) {
        kandN[i] = new BFSURL((String)kand.elementAt(i));
        kandN[i].initIndeksi();
      }
     //kand.removeAllElements();       //erase vector of possible outputs
    }
  //--------------------------------------------------------------------
    static public void initKeyParsing() {
      for (int i=0; i<n; i++) {   //look for keywords in input documents
        try {
          DataInputStream dis;
          String s=ulazN[i].getFileName();
          dis = new DataInputStream(new FileInputStream(s));
          if (BFS.coms) {
            s=ulazN[i].getHttpName();
            frame.pisi("KeyParsing "+s);
          }
          KeyParser.init();
          KeyParser.Fill(dis);
          KeyParser.arrange();
          KeyParser.purge();          
          dis.close();
        }
        catch(Exception e) { frame.pisi("I/0 Error "); }
      }
    }
  //--------------------------------------------------------------------
    static public void initBFSParsingUlazN() {
      for (int i=0; i<n; i++)       //prepare input documents for search
        initBFSParsing (ulazN[i],true);
    }
  //--------------------------------------------------------------------
    static public void initBFSParsingKandN() {
      for (int i=0; i<nK; i++) {   //prepare possible outputs for search
        initBFSParsing (kandN[i],false);
        double d = kandN[i].js();
        kandJS.put(kandN[i].getHttpName(),String.valueOf(d));
      }
    }
  //--------------------------------------------------------------------
    static public void initBFSParsing(BFSURL u, boolean b) {
      try {                                //look for links and keywords
        DataInputStream dis;
        dis = new DataInputStream(new FileInputStream(u.getFileName()));
        if (BFS.coms) {        
          frame.pisi("BFSParsing "+u.getHttpName());
        }
        BFSParser.parsing(u,dis,b);
        dis.close();
      }
      catch(Exception e){frame.pisi("I/0 Error "+e.toString());}
    }
  //--------------------------------------------------------------------
    static public void initL() {
      l = nizKW.size();                        //init number of keywords
      for (int i=0; i<n; i++) ulazN[i].initIndeksi();
      w = new int[l];
      maxKW=0;
      for (int i=0; i<l; i++) {
        w[i]=wordCount((String)nizKW.elementAt(i));
        if (maxKW<w[i]) maxKW=w[i];
      } 
      if (BFS.coms) frame.pisi("maxKW="+maxKW);
    }
  //--------------------------------------------------------------------
    static public void initA2() {
      df = new int[l];                                 //create array a2
      a2 = new double[l];
      for (int i=0; i<l; i++) df[i]=0;
      for (int i=0; i<l; i++) 
        for (int j=0; j<n; j++) if (ulazN[j].indeksi[i]>0) df[i]++;
      for (int i=0; i<l; i++) 
        if (df[i]==0) a2[i]=0;
        else a2[i]=(n*w[i]/df[i])*(n*w[i]/df[i]);
    }
  //--------------------------------------------------------------------
    static private int wordCount(String s) {
      int bb=1;                                //count words in string s
      int start=0;
      int pos=0;
      if (s.length()==0) return 0;
      else
        do {
          pos=s.indexOf(' ',start);
          if (pos != -1) { bb++; start=pos+1; }
        }
        while (pos!=-1);
        return bb;
      }
  //--------------------------------------------------------------------
    static public void print(Vector v, String s) {
      if (v.size()==0) { 
        frame.pisi("Vector '"+s+"' is empty.");
        return; 
      }
      frame.pisi("Number of elements for vector "+s+" = "+v.size());
      for(int i=0; i<v.size(); i++)
      frame.pisi(s+"["+i+"]="+v.elementAt(i));
    }
  //-------------------------------------------------------------------
    static public void print(Hashtable ht, String s) {
      if (ht.size()==0) {                             //print hashtable
        frame.pisi("Hashtable '"+s+"' is empty"); 
        return; 
      }
      Hashtable temp = new Hashtable();
      temp=(Hashtable)ht.clone();
      frame.pisi("Content of Hashtable '"+s+"' is \n"); 
      while (temp.size()!=0) {
        String key = maxEl(temp);          //returns URL with highest JS
        double el = new Double((String)temp.get(key)).doubleValue();
        el*=100;
        int i1=(int)Math.floor(el);
        el=100*(el-i1);
        int i2=(int)Math.ceil(el);
        if (i2==100) { i1++; i2=0; }
        String proc="";
        if (i1<10) proc="  "; else if (i1<100) proc=" ";
        proc+=String.valueOf(i1)+".";
        if (i2<10) proc+="0"+String.valueOf(i2)+"%"; 
        else proc+=String.valueOf(i2)+"%";
        frame.pisi(proc+"   "+key);
        temp.remove(key);                  //erasing URL with highest JS
      }
    }
  //-------------------------------------------------------------------
    static public String maxEl(Hashtable temp) {
      if (temp.size()==0)     //returns URL of document with highest JS
        return "";               //empty string is sign for empty table
      else {
        Enumeration e = temp.elements();
        String maxE = (String)e.nextElement();
        double maxD = new Double(maxE).doubleValue();
        Enumeration k = temp.keys(); 
        String maxK = (String)k.nextElement();
        while (k.hasMoreElements()) {
          String key = (String)k.nextElement();
          String el = (String)e.nextElement(); 
          double d = new Double(el).doubleValue();
          if (d>maxD) { maxD=d; maxK=key; }
        }
        return maxK;
      }
    }
  }
