/*  Virtual Agent
 */
package Project1;
import COM.meitca.concordia.*;
import java.util.*;
import java.net.*;
import java.io.*;

public abstract class VirtAgent extends Agent	//note: maybe should be CollaboratorAgent
{
	protected
		//URL urls[];						//stack for URLs to be visited
		Vector urls;
		int url_no;						//stack pointer
		
	//Common procedures
		
	//Constructor
	public VirtAgent(){					
		url_no=0;						//initialize stack
		urls = new Vector();
	};	
	
	//Abstract procedure that is invoked on remote server 
	abstract public void run();			
	
	//push URL on stack
	public void pushTask(URL u){			
		urls.insertElementAt(u,url_no++);						//push URL on the stack
	};
	
	//pop URL from stack
	public void popTask(URL u){			
		if(url_no>0){
			u = (URL)urls.elementAt(url_no);					//pop URL on the stack
			urls.removeElementAt(--url_no);
		};
	};
	
	//get URL from stack
	public void getTask(URL u, int n){			
		if(n>=0 && n<url_no){
			u = (URL)urls.elementAt(n);					//push URL on the stack
		};
	};

	//fetch data
	abstract public void getData();		
}
