package xml;

import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import model.gui.Container;
import model.gui.Line;
import model.gui.Shape;
import model.gui.Text;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


public class GuiParser {
	private static int count = 0;
	
	public GuiParser(){
		
	}
	
	public Container parse(String fileName){
		try{
			Document doc = null;
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			XPathFactory xpathFactory = XPathFactory.newInstance();
			DocumentBuilder builder = null;
			builder = factory.newDocumentBuilder();
			doc = builder.parse(fileName);
			XPath xpath = xpathFactory.newXPath();
			XPathExpression expr = null;
			
			// Containers
			expr = xpath.compile("/Container");
			NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
			count += nodes.getLength();
			if(nodes.getLength() > 0){
				return createContainer(nodes.item(0), null);
			}
			
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	
	private Container createContainer(Node node, Container parent){
		double widthC = Double.parseDouble(node.getAttributes().getNamedItem("widthC").getNodeValue());
		double heightC = Double.parseDouble(node.getAttributes().getNamedItem("heightC").getNodeValue());
		double apsX = Double.parseDouble(node.getAttributes().getNamedItem("apsX").getNodeValue());
		double apsY = Double.parseDouble(node.getAttributes().getNamedItem("apsY").getNodeValue());
		double width = Double.parseDouble(node.getAttributes().getNamedItem("width").getNodeValue());
		double height = Double.parseDouble(node.getAttributes().getNamedItem("height").getNodeValue());
		Container container = new Container(parent, widthC, heightC, apsX, apsY, width, height);
		for(int i = 0; i < node.getChildNodes().getLength(); i++){
			Node childNode = node.getChildNodes().item(i);
			if("Container".equals(childNode.getNodeName())){
				Container containerCH = createContainer(childNode, container);
				container.addContainer(containerCH);
				
			}else if("Shape".equals(childNode.getNodeName())){
				Shape shape = createShape(childNode, container);
				container.addShape(shape);
			
			}else if("Line".equals(childNode.getNodeName())){
				Line line = createLine(childNode);
				container.addLine(line);
			}
		}
		return container;
	}
	
	private Shape createShape(Node node, Container container){
		double apsX = Double.parseDouble(node.getAttributes().getNamedItem("apsX").getNodeValue());
		double apsY = Double.parseDouble(node.getAttributes().getNamedItem("apsY").getNodeValue());
		double width = Double.parseDouble(node.getAttributes().getNamedItem("width").getNodeValue());
		double height = Double.parseDouble(node.getAttributes().getNamedItem("height").getNodeValue());
		GeneralPath generalPath = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
		Shape shape = new Shape(apsX, apsY, width, height, generalPath);
		for(int i = 0; i < node.getChildNodes().getLength(); i++){
			Node childNode = node.getChildNodes().item(i);
			if("MoveTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				generalPath.moveTo(x, y);
			}else if("LineTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				generalPath.lineTo(x, y);
			}else if("ArcTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				double a = Double.parseDouble(childNode.getAttributes().getNamedItem("a").getNodeValue());
				double b = Double.parseDouble(childNode.getAttributes().getNamedItem("b").getNodeValue());
				double c = Double.parseDouble(childNode.getAttributes().getNamedItem("c").getNodeValue());
				double d = Double.parseDouble(childNode.getAttributes().getNamedItem("d").getNodeValue());
				Arc2D arc2D = new Arc2D.Double(x, y, a, b, c, d, Arc2D.OPEN);
				generalPath.append(arc2D, true);
			}else if("EllipticalArcTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				double a = Double.parseDouble(childNode.getAttributes().getNamedItem("a").getNodeValue());
				double b = Double.parseDouble(childNode.getAttributes().getNamedItem("b").getNodeValue());
				double c = Double.parseDouble(childNode.getAttributes().getNamedItem("c").getNodeValue());
				double d = Double.parseDouble(childNode.getAttributes().getNamedItem("d").getNodeValue());
				generalPath.curveTo(x, y, a, b, c, d);
			}else if("Text".equals(childNode.getNodeName())){
				double apsXC = Double.parseDouble(childNode.getAttributes().getNamedItem("apsX").getNodeValue());
				double apsYC = Double.parseDouble(childNode.getAttributes().getNamedItem("apsY").getNodeValue());
				double widthC = Double.parseDouble(childNode.getAttributes().getNamedItem("width").getNodeValue());
				double heightC = Double.parseDouble(childNode.getAttributes().getNamedItem("height").getNodeValue());
				double angleC = Double.parseDouble(childNode.getAttributes().getNamedItem("angle").getNodeValue());
				double sizeC = Double.parseDouble(childNode.getAttributes().getNamedItem("size").getNodeValue());
				String textC = childNode.getAttributes().getNamedItem("text").getNodeValue();
				Text text = new Text(apsXC, apsYC, widthC, heightC, angleC, sizeC, textC);
				shape.addText(text);
			}else if("Shape".equals(childNode.getNodeName())){
				createShape(childNode, container);
			}else if("Container".equals(childNode.getNodeName())){
				createContainer(childNode, container);
			}else if("Line".equals(childNode.getNodeName())){
				
			}
		}
		
		return shape;
	}
	
	private Line createLine(Node node){
		int id = Integer.parseInt(node.getAttributes().getNamedItem("id").getNodeValue());
		double apsX = Double.parseDouble(node.getAttributes().getNamedItem("apsX").getNodeValue());
		double apsY = Double.parseDouble(node.getAttributes().getNamedItem("apsY").getNodeValue());
		double width = Double.parseDouble(node.getAttributes().getNamedItem("width").getNodeValue());
		double height = Double.parseDouble(node.getAttributes().getNamedItem("height").getNodeValue());
		GeneralPath generalPath = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
		Line line = new Line(id, apsX, apsY, width, height, generalPath);
		for(int i = 0; i < node.getChildNodes().getLength(); i++){
			Node childNode = node.getChildNodes().item(i);
			if("MoveTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				generalPath.moveTo(x, y);
			}else if("LineTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				generalPath.lineTo(x, y);
			}else if("ArcTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				double a = Double.parseDouble(childNode.getAttributes().getNamedItem("a").getNodeValue());
				double b = Double.parseDouble(childNode.getAttributes().getNamedItem("b").getNodeValue());
				double c = Double.parseDouble(childNode.getAttributes().getNamedItem("c").getNodeValue());
				double d = Double.parseDouble(childNode.getAttributes().getNamedItem("d").getNodeValue());
				Arc2D arc2D = new Arc2D.Double(x, y, a, b, c, d, Arc2D.OPEN);
				generalPath.append(arc2D, true);
			}else if("EllipticalArcTo".equals(childNode.getNodeName())){
				double x = Double.parseDouble(childNode.getAttributes().getNamedItem("x").getNodeValue());
				double y = Double.parseDouble(childNode.getAttributes().getNamedItem("y").getNodeValue());
				double a = Double.parseDouble(childNode.getAttributes().getNamedItem("a").getNodeValue());
				double b = Double.parseDouble(childNode.getAttributes().getNamedItem("b").getNodeValue());
				double c = Double.parseDouble(childNode.getAttributes().getNamedItem("c").getNodeValue());
				double d = Double.parseDouble(childNode.getAttributes().getNamedItem("d").getNodeValue());
				generalPath.curveTo(x, y, a, b, c, d);
			}else if("Text".equals(childNode.getNodeName())){
				double apsXC = Double.parseDouble(childNode.getAttributes().getNamedItem("apsX").getNodeValue());
				double apsYC = Double.parseDouble(childNode.getAttributes().getNamedItem("apsY").getNodeValue());
				double widthC = Double.parseDouble(childNode.getAttributes().getNamedItem("width").getNodeValue());
				double heightC = Double.parseDouble(childNode.getAttributes().getNamedItem("height").getNodeValue());
				double angleC = Double.parseDouble(childNode.getAttributes().getNamedItem("angle").getNodeValue());
				double sizeC = Double.parseDouble(childNode.getAttributes().getNamedItem("size").getNodeValue());
				String textC = childNode.getAttributes().getNamedItem("text").getNodeValue();
				Text text = new Text(apsXC, apsYC, widthC, heightC, angleC, sizeC, textC);
				line.addText(text);
			}
		}
		return line;
	}
	
	public static void main(String[] args){
		GuiParser parserSim = new GuiParser();
		parserSim.parse("d:/projects/Test/gui.xml");
	}
}
