package system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

/**
 * Progress Bar komponenta, koja se prikazuje pri pokretanju i ucitavanju novog projekta.
 */
public abstract class ProgressBar extends SwingWorker<Void, Void>{


	private static final long serialVersionUID = 1L;
	private JProgressBar progressBar;
	private JDialog parent;
	private String comment;

	public ProgressBar(JFrame frame, String comment) {
		this.comment = comment;
		parent = new JDialog(frame, comment);
		parent.setPreferredSize(new Dimension(230, 85));
		progressBar = new JProgressBar();
		progressBar.setIndeterminate(true);
		progressBar.setBackground(Color.WHITE);
		JPanel p = new JPanel(new BorderLayout());
		p.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
		p.add(progressBar, BorderLayout.CENTER);
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(p, BorderLayout.PAGE_START);
		panel.setOpaque(true);
		parent.setBounds(frame.getX() + (frame.getWidth()-200)/2, frame.getY() + (frame.getHeight()-120)/2, 0, 0);
		parent.setContentPane(panel);
//		parent.setLocationRelativeTo(frame);
		parent.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		parent.setResizable(false);
        parent.pack();
        parent.setModal(true);
        execute();
		parent.setVisible(true);
	}
	
	@Override
	protected void done() {
		Toolkit.getDefaultToolkit().beep();
		parent.setVisible(false);
	}
}
