package simgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import system.AppConstants;

public class SimGenModel{
	private static SimGenModel instance = null;
	private List<ElementModel> elementModelList;
	private Map<String, ElementModel> elementsMap;
	private String currentProject = null;
	private LinkedList<GuiListener> listenerList;
	private String message = "";
	
	public static SimGenModel getInstance(){
		if(instance == null){
			instance = new SimGenModel();
		}
		return instance;
	}
	
	private SimGenModel(){
		this.elementModelList = new LinkedList<ElementModel>();
		this.elementsMap = new HashMap<String, ElementModel>();
		this.listenerList = new LinkedList<GuiListener>();
	}
		
	public void initElements(String folderName){
		String elementName = "";
		File folder = new File("src\\" + folderName);
		File[] files = folder.listFiles();
		for(int i = 0; i < files.length; i++){
			elementName = files[i].getName().split(".java")[0];
			ElementModel element = new ElementModel(elementName, elementName, ElementModel.SINGLE_TYPE);
			elementModelList.add(element);
			elementsMap.put(elementName, element);
		}
	}
	
	public Vector<String> getAllClasses(String folderName){
		String elementName = "";
		File folder = new File("src\\" + folderName);
		File[] files = folder.listFiles();
		Vector<String> elements = new Vector<String>();
		for(int i = 0; i < files.length; i++){
			elementName = files[i].getName().split(".java")[0];
			elements.add(elementName);
		}
		return elements;
	}
	
	public List<ElementModel> getElemetnModelList(){
		return new LinkedList<ElementModel>(elementModelList);
	}
	
	public HashMap<String, ElementModel> getElementsMap(){
		return new HashMap<String, ElementModel>(elementsMap);
	}
	
	public void createXMLFile(String fileName){
		try{
			String root = "root";
			DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder documentBuilder =  documentBuilderFactory.newDocumentBuilder();
			Document document = documentBuilder.newDocument();
			Element rootElement = document.createElement(root);
			document.appendChild(rootElement);
		    for(ElementModel elementModel : elementModelList){
		    	String element = "element";
		    	Element em = document.createElement(element);
		    	em.setAttribute("className", elementModel.getClassName());
		    	em.setAttribute("elementName", elementModel.getElementName());
		    	em.setAttribute("type", elementModel.getType()+"");
		    	rootElement.appendChild(em);
		    }
		    TransformerFactory transformerFactory = TransformerFactory.newInstance();
		    Transformer transformer;
		
			transformer = transformerFactory.newTransformer();
			DOMSource source = new DOMSource(document);
			StreamResult result =  new StreamResult(new File(fileName));
			transformer.transform(source, result);
		}catch(TransformerConfigurationException e){
			e.printStackTrace();
		}catch(TransformerException e){
			e.printStackTrace();
		}catch(ParserConfigurationException e){
			e.printStackTrace();
		}
	}
	
	public void init(String fileName){
		try{
			Document doc = null;
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			XPathFactory xpathFactory = XPathFactory.newInstance();
			DocumentBuilder builder = null;
			builder = factory.newDocumentBuilder();
			File file = new File(fileName);
			doc = builder.parse(file);
			XPath xpath = xpathFactory.newXPath();
			XPathExpression expr = null;
			expr = xpath.compile("//element");
			Object result = expr.evaluate(doc, XPathConstants.NODESET);
			NodeList nodes = (NodeList) result;
			elementModelList.clear();
			for(int i = 0; i < nodes.getLength(); i++){
				Node node = nodes.item(i);
				String className = node.getAttributes().getNamedItem("className").getNodeValue();
				String elementName = node.getAttributes().getNamedItem("elementName").getNodeValue();
				int type = Integer.parseInt(node.getAttributes().getNamedItem("type").getNodeValue());
				ElementModel element = new ElementModel(className, elementName, type);
				elementModelList.add(element);
				elementsMap.put(elementName, element);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public void saveElementsModel(LinkedList<ElementModel> elementModelList){
		this.elementModelList = elementModelList;
		elementsMap.clear();
		for(ElementModel element : elementModelList){
			elementsMap.put(element.getElementName(), element);
		}
		createXMLFile(AppConstants.PROJECTS_DIR + currentProject + "/config.xml");
	}
	
	public String getCurrentProject() {
		return currentProject;
	}

	public void setCurrentProject(String currentProject) {
		this.currentProject = currentProject;
	}
	
	public void addListener(GuiListener listener){
		listenerList.add(listener);
	}
	
	public void removeListener(GuiListener listener){
		listenerList.remove(listener);
	}
	
	private void fireChange(){
		for(GuiListener listener : listenerList){
			listener.onChanged(message);
		}
	}
	
	public void setMessage(String s){
		message = s;
		fireChange();
	}
	
	public static void main(String[] args){
		SimGenModel testModel = new SimGenModel();
	}
}
