package simgen;

import java.util.List;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ElementsTableModel implements TableModel{
	private List<ElementModel> list;
	private String[] columns = new String[]{"File name", "Element name", "Type"};
	
	public ElementsTableModel(List<ElementModel> list){
		this.list = list;
	}
	
	public void addElement(ElementModel element){
		list.add(element);
	}

	@Override
	public void addTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
	}

	@Override
	public Class<?> getColumnClass(int columnIndex){
		return columns[columnIndex].getClass();
	}

	@Override
	public int getColumnCount(){
		return columns.length;
	}

	@Override
	public String getColumnName(int columnIndex){
		return columns[columnIndex];
	}

	@Override
	public int getRowCount(){
		return list.size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex){
		switch(columnIndex){
		case 0:
			return list.get(rowIndex).getClassName();
		case 1:
			return list.get(rowIndex).getElementName();
		case 2:
			return list.get(rowIndex).getType();
		default:
			break;
		}
		return null;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex){
		return columnIndex != 0;
	}

	@Override
	public void removeTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex){
		switch(columnIndex){
		case 1:
			list.get(rowIndex).setElementName(value.toString());
			break;
		case 2:
			list.get(rowIndex).setType(Integer.parseInt(value.toString()));
			break;
		}
	}


}
