package model.visio;

public class StaticElem {
	private int maxUIndex=0;
	private int maxIIndex=0;
	
	private SimElement[] ins = new SimElement[256];
	private SimElement[] outs = new SimElement[256];
	
	public StaticElem(){
		for(int i=0; i<256; i++){
			ins[i] = new SimElement(-1);
			outs[i] = new SimElement(-1);
		}
	}
		
	public void addIn(int index, SimElement simElem){
		ins[index] = simElem;
		if(index >= maxUIndex){
			maxUIndex = index + 1;
		}
	}
	
	public void addOut(int index, SimElement simElem){
		outs[index] = simElem;
		if(index >= maxIIndex){
			maxIIndex = index + 1;
		}
	}
	
	public void addNextIn(SimElement simElem){
		ins[maxUIndex++] = simElem;
	}
	
	public void addNextOut(SimElement simElem){
		outs[maxIIndex++] = simElem;
	}
	
	public SimElement[] getIns(){
		return ins;
	}
	
	public SimElement[] getOuts(){
		return outs;
	}
	
	public String toString(){
		return "";
	}
}
