package model.visio;

import java.util.Map;

import system.AppConstants;

public class SimElement {
	private static int countId = -2;
	private int id;
	private int value;
	private int count;
	private String text = "";
	private String prefix = "";
	
	
	private int maxUIndex=0;
	private int maxIIndex=0;
	
	private SimElement[] ins = new SimElement[256];
	private SimElement[] outs = new SimElement[256];
	private Master master = null;
	
	public SimElement(Master master){
		id = countId++;
		String masterName = master.getName();
		value = 1;
		count = 1;
		Map<String, String> properties = master.getProperties();
		if(properties.containsKey(AppConstants.COUNT)){
			count = Integer.parseInt(properties.get(AppConstants.COUNT), 16);
		}
		if(properties.containsKey(AppConstants.VALUE)){
			value = Integer.parseInt(properties.get(AppConstants.VALUE), 16);
		}
		if(properties.containsKey(AppConstants.PREFIX)){
			prefix = properties.get(AppConstants.PREFIX);
		}
		
		this.master = master;
//		for(int i=0; i<256; i++){
//			ins[i] = new SimElem(-1);
//			outs[i] = new SimElem(-1);
//		}
		if(masterName.contains(AppConstants.DECODER)){
			Simulation.obradaDC(this);
		}
	}
	
	public SimElement(int id){
		this.id = id;
	}
	
	public SimElement(Master master, int vrednost){
		this(master);
		this.value = vrednost;
	}
		
	public void addIn(int index, SimElement simElem){
		ins[index] = simElem;
		if(index >= maxUIndex){
			maxUIndex = index + 1;
		}
	}
	
	public void addOut(int index, SimElement simElem){
		outs[index] = simElem;
		if(index >= maxIIndex){
			maxIIndex = index + 1;
		}
	}
	
	public void addNextIn(SimElement simElem){
		ins[maxUIndex++] = simElem;
	}
	
	public void addNextOut(SimElement simElem){
		outs[maxIIndex++] = simElem;
	}
	
	public int getId(){		
		return id;
	}
	
	public void setText(String text){
		this.text = text;
	}
	
	public void setValue(int value){
		this.value = value;
	}
	
	public void setPrefix(String prefix){
		this.prefix = prefix;
	}
	
	public String getPrefix(){
		return prefix;
	}
	
	public void setCount(int count){
		this.count = count;
	}
	
	public int getCount(){
		return count;
	}
	
	public Master getMaster(){
		return master;
	}
	
	public SimElement[] getIns(){
		return ins;
	}
	
	public SimElement[] getOuts(){
		return outs;
	}
	
	public String toString(){
		String in = maxUIndex == 0 ? " " : "";
		String out = maxIIndex == 0 ? " " : "";
		for(int i=0; i<maxUIndex; i++){
			in += (ins[i]!=null ? ins[i].id : "-1") + ((i==maxUIndex-1)?"":" ");
		}
		for(int i=0; i<maxIIndex; i++){
			out += (outs[i]!=null ? outs[i].id : "-1") + ((i==maxIIndex-1)?"":" ");
		}
		
		if(master != null){
			return "<element name='" + master.getName() + "' id='" + id + "' ins='" + in + "' outs='" + out 
			+ "' count='" + count + "' value='" + value + "'" + " text='" + text + "'" + "/>\n";
		}
		return "";
	}
}
