package model.visio;

public class LineTo implements Streak{
	private double x;
	private double y;
	
	public LineTo(String x, String y){
		this.x = Double.parseDouble(x);
		this.y = Double.parseDouble(y);
	}
	public LineTo(double x, double y){
		this.x = x;
		this.y = y;
	}
	
	public String toString(){
		return "<LineTo x='" + x + "' y='" + y + "'/>";
	}
	
	public Streak clone(){
		return new LineTo(x,y);
	}
	
	public Point recalculate(XForm xf, Point begin){
		x += xf.getPinX();
		y = xf.getPinY() - y;
		return new Point(x, y);
	}
}
