package model.visio;
import java.util.*;

public class Geom {
	private int noShow;
	private List<Streak> streaks = new LinkedList<Streak>();
	
	public Geom(String noShow){
		this.noShow = Integer.parseInt(noShow);
	}
	
	public Geom(int noShow){
		this.noShow = noShow;
	}
	
	public void addStreak(Streak streak){
		streaks.add(streak);
	}
	
	public Geom clone(){
		Geom ret = new Geom(noShow);
		for(Streak streak : streaks){
			ret.streaks.add(streak.clone());
		}
		return ret;
		
	}
	
	public void recalculate(XForm xf){
		Point begin = new Point(0, 0);
		for(Streak streak : streaks){
			begin = streak.recalculate(xf, begin);
		}
	}
	
	public String toString(){
		String s = new String();
		if(noShow == 0){
			for(Streak streak : streaks){
				s += streak;
			}
		}
		return s;		
	}
	
}
