package model.visio;

import java.util.*;

import system.AppConstants;

import xml.VisioParser;

public class Document{
	private Hashtable<Integer, Master> masters = new Hashtable<Integer, Master>();
	private Hashtable<String, Page> pages = new Hashtable<String, Page>();
	private Hashtable<String, Module> modules = new Hashtable<String, Module>();
	
	public Document(){
	
	}
	
	public void addMaster(Master master){
		masters.put(new Integer(master.getId()), master);
	}
	
	public void addPage(Page page){
		pages.put(page.getName(), page);
	}
	
	public Page getPage(String name){
		return pages.get(name);
	}
	
	public Hashtable<String, Page> getPages(){
		return new Hashtable<String, Page>(pages);
	}
	
	public Master getMaster(Integer id){
		return masters.get(id);
	}
	
	public Hashtable<Integer, Master> getMasters(){
		return new Hashtable<Integer, Master>(masters);
	}
	
	public void putModule(String key, Module module){
		modules.put(key, module);
	}
	
	public Module getModule(String key){
		return modules.get(key);
	}
	
	public Map<String, Module> getModules(){
		return new HashMap<String, Module>(modules);
	}
	
	public void execute(String projectName){
		Enumeration<Page> e = pages.elements();
		while(e.hasMoreElements()){
			Page page = e.nextElement();
			page.executeSim(this, masters, new ModuleParam(new SimElement[]{}, new SimElement[]{}, ""));
		}
		// obrada modula
		for(Module module : modules.values()){
			VisioParser parserSim = new VisioParser(AppConstants.MODULE_DIR + module.getMasterName() + AppConstants.FILE_EXTENSION, module.getObrada(), module.getMasterName());
			parserSim.parse();
//			SimElem simElem = module.getSimElem();
			StaticElem staticElem = module.getStaticElem();
			ModuleParam moduleParam = new ModuleParam(staticElem.getIns(), staticElem.getOuts(), module.getPrefix());
			module.getObrada().executeModuleSim(moduleParam);
		}
		
		Simulation.outToFile(projectName);
		
		Page trenutnaStrana = (Page) pages.get("main");
		if(trenutnaStrana != null){	
			System.out.println("--------Sada dolazi obrada !!!!--------");
			Container glavni = new Container();
			trenutnaStrana.executeGui(pages, glavni, new XForm());
			Output.write(glavni+"");
		}
	}
	
	public void executeModuleSim(ModuleParam moduleParam){
		Enumeration<Page> e = pages.elements();
		while(e.hasMoreElements()){
			Page page = e.nextElement();
			page.executeSim(this, masters, moduleParam);
		}
		for(Module module : modules.values()){
			VisioParser parserSim = new VisioParser(AppConstants.MODULE_DIR + module.getMasterName() + AppConstants.FILE_EXTENSION, module.getObrada(), module.getMasterName());
			parserSim.parse();
			StaticElem staticElem = module.getStaticElem();
			ModuleParam moduleParamC = new ModuleParam(staticElem.getIns(), staticElem.getOuts(), module.getPrefix());
			module.getObrada().executeModuleSim(moduleParamC);
		}
	}
}
