package model.visio;

public class Connector{
	private double x;
	private double y;
	private int d;
	
	private SimElement simElem = null;
	private StaticElem staticElem = null;
	
	public Connector(String x, String y, String d){
		this.x = Double.parseDouble(x);
		this.y = Double.parseDouble(y);
		this.d = Integer.parseInt(d);
	}
	
	public void recalculate(XForm xxf){
		x += xxf.getPinX();
		y = xxf.getPinY() - y;
	}
	public void addSimElem(SimElement simElem){
		this.simElem = simElem;
	}	
	
	public Point getPoint(){
		return new Point(x, y);
	}
	
	public SimElement getSimElem(){
		return simElem;
	}
	
	public int getD(){
		return d;
	}
	
	public StaticElem getStaticElem() {
		return staticElem;
	}

	public void addStaticElem(StaticElem staticElem) {
		this.staticElem = staticElem;
	}
}
