package model.visio;

public class ArcTo implements Streak{
	private double x;
	private double y;
	private double a;
	
	private EllipArcTo arcTo;
	
	public ArcTo(String x, String y, String a){
		this.x = Double.parseDouble(x);
		this.y = Double.parseDouble(y);
		this.a = Double.parseDouble(a);
	}
	
	public ArcTo(double x, double y, double a){
		this.x = x;
		this.y = y;
		this.a = a;
	}
	
	public String toString(){		
		return arcTo + "";
	}
	
	public Streak clone(){
		return new ArcTo(x, y, a);
	}
	
	private void calculateControlPoint (Point begin, Point end, double aa){
		Point t3 = new Point();
		Point c = new Point();
		t3.setX((begin.getX() + end.getX())/2);
		t3.setY((begin.getY() + end.getY())/2);
		
		if(end.getX() < begin.getX()){
			aa = -aa;
		}
		
		if((end.getY() - begin.getY()) < EPSILON){
			c.setX(t3.getX());
			c.setY(t3.getY() + aa);
		}else{
			double k2 = (begin.getX() - end.getX())/(-end.getY() + begin.getY());
			c.setX(aa/Math.sqrt(1+k2*k2)+t3.getX());
			c.setY(aa*k2/Math.sqrt(1+k2*k2)+t3.getY());
		}
		
		arcTo = new EllipArcTo(end.getX(), end.getY(), c.getX(), c.getY(), 0, 1);
		arcTo.calculateControlPiont(begin, end, c, 0, 1);
	}
	
	public Point recalculate(XForm xf, Point begin){
		x+= xf.getPinX();
		y = xf.getPinY() - y;
		calculateControlPoint(begin, new Point(x, y), a);
		return new Point(x, y);
	}
}
