package model.gui;

import gui.*;

//import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.BufferedImage;
import javax.swing.*;


public class Picture extends JPanel{
	
	private InterfaceSimGui interfejsSimGui;
	private static final long serialVersionUID = 1L;	
	private BufferedImage bafer;
	private double scaleX;
	private double scaleY;
	
	public Picture(InterfaceSimGui iinterfejsSimGui){
		interfejsSimGui = iinterfejsSimGui;
		scaleX = 160;
		scaleY = 160;
		addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent e){
				Point t = new Point(e.getX(),e.getY());
				Container newContainer = interfejsSimGui.getCurrentContainer().containerListener(t, scaleX, scaleY);
				if(newContainer != null){
					interfejsSimGui.setCurrentContainer(newContainer);
					Picture.this.repaint();
				}
			}
		});
		this.addMouseMotionListener(new MouseMotionAdapter(){
			public void mouseMoved(MouseEvent e){	
				Point t = new Point(e.getX(), e.getY());
				if(interfejsSimGui.getCurrentContainer().containerListener(t, scaleX, scaleY) != null){
					Picture.this.setCursor(new Cursor(Cursor.HAND_CURSOR));
				}else{
					Picture.this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				}
			}
		});
	}
	
	@Override
	protected void paintComponent(Graphics g){
		super.paintComponent(g);
		boolean changed = interfejsSimGui.getChange();
		Graphics2D g2d = (Graphics2D)g;
		Graphics2D g2d2 = null; 
		AffineTransform reset = new AffineTransform();
		AffineTransform at = AffineTransform.getScaleInstance(scaleX, scaleY);			
		AffineTransform at2 = AffineTransform.getScaleInstance(scaleX, scaleY);
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setStroke(new BasicStroke(0.010f));
		g2d.setTransform(at);			
		g2d.setPaint(Color.BLACK);
		bafer = new BufferedImage(getWidth(), getHeight(), BufferedImage.BITMASK);
		g2d2 = ((Graphics2D)bafer.getGraphics());
		g2d2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2d2.setStroke(new BasicStroke(0.010f));
		g2d2.setTransform(at2);
		g2d2.setColor(Color.BLACK);
		interfejsSimGui.getCurrentContainer().paint(g2d, g2d2, true, scaleX, scaleY);
		g2d.setTransform(reset);
	}
	
	public double getScaleX(){
		return scaleX;
	}

	public void setScaleX(double scaleX){
		this.scaleX = scaleX;
	}

	public double getScaleY(){
		return scaleY;
	}

	public void setScaleY(double scaleY){
		this.scaleY = scaleY;
	}
	
	public void setZoomLevel(double level){
		if(scaleX > 90 || level > 0){
			scaleX = scaleY += level * 10;
			this.setPreferredSize(new Dimension((int)(this.getPreferredSize().getWidth() + level*45), (int)(this.getPreferredSize().getHeight() + level*45)));
			revalidate();
		}
	}
}

