package model.gui;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class MouseWheelListenerOnPicture implements MouseWheelListener{
	private Picture picture;
	
	public MouseWheelListenerOnPicture(Picture picture){
		this.picture = picture;
	}
	
	@Override
	public void mouseWheelMoved(MouseWheelEvent e){
		int count = e.getWheelRotation();
		if((e.getModifiersEx() & MouseWheelEvent.CTRL_DOWN_MASK) == MouseWheelEvent.CTRL_DOWN_MASK){
			picture.setZoomLevel(-count);
			picture.repaint();
		}
	}
}
