package model.gui;

import model.sim.*;

import java.awt.*;
import java.awt.Shape;
import java.awt.geom.*;
import java.util.ArrayList;

import util.Arrow;

public class Line {
	
	private  int id;
	private double apsX;
	private double apsY;
	private double width;
	private double height;
	private GeneralPath generalPath;
	
	private ArrayList<Text> texts = new ArrayList<Text>();
	
	public Line(int id, double apsX, double apsY, double width, double height, GeneralPath generalPath){
		this.id = id;
		this.apsX = apsX;
		this.apsY = apsY;
		this.width = width;
		this.height = height;
		this.generalPath = generalPath;
	}
	
	public void addText(Text text) {
		texts.add(text);
	}
	
	public Text getText(int i) {
		return texts.get(i);
	}
	
	public void paint(Graphics g){
		Graphics2D g2d = (Graphics2D)g;
		if(ElementSim.getElement(id).getNumLines() == 1){
			if(ElementSim.getElement(id).getValue(0) == 0){
				g2d.setPaint(Color.BLUE);
			}else if(ElementSim.getElement(id).getValue(0) == 1){
				g2d.setPaint(Color.RED);
			}else if(ElementSim.getElement(id).getValue(0) == -2){
				g2d.setPaint(Color.BLACK);
			}else{
				g2d.setPaint(Color.GREEN);
			}
		}
		g2d.draw(generalPath);
		g2d.setPaint(Color.BLACK);
	}
	
	public void drawText(Graphics g, double scaleX, double scaleY){
		Graphics2D g2d = (Graphics2D)g;		
		if(ElementSim.getElement(id).getNumLines() != 1){
			g2d.setPaint(Color.BLACK);
			int vrednost = ElementSim.getElement(id).getValue(0);
			String tekst = Integer.toString(vrednost,16);
			int brMesta = (ElementSim.getElement(id).getNumLines()-1)/4 - tekst.length() + 1;
			if(vrednost >= 0){
				for(Text text : texts){
					for(int j = 0; j < brMesta; j++)
						tekst = "0" + tekst;
					text.drawValue(g, tekst, scaleX, scaleY);
				}
			}else{
				tekst = "highZ";
				brMesta  = 0;
				for(Text text : texts){
					text.drawValue(g, tekst, scaleX, scaleY);
				}
			}
		}
	}
}
