package gui;

import java.util.List;
import java.util.Map;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import model.sim.ElementSim;
import elements.Dynamicconnector;

public class SignalGeneratorTableModel implements TableModel{
	private static final long serialVersionUID = 1L;

	private SimGui simGui;
	private Map<String, Integer> signalMap = ElementSim.getInSignals();
	private List<String> signalsList = ElementSim.getInSignalsList();
	private String[] columns = new String[]{"Signal", "Value"};
	public SignalGeneratorTableModel(SimGui simGui){
		this.simGui = simGui;
	}
	
	@Override
	public void addTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
	}

	@Override
	public Class<?> getColumnClass(int columnIndex){
		return columns[columnIndex].getClass();
	}

	@Override
	public int getColumnCount(){
		return columns.length;
	}

	@Override
	public String getColumnName(int columnIndex){
		return columns[columnIndex];
	}

	@Override
	public int getRowCount(){
		return signalMap.size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex){
		switch(columnIndex){
		case 0:
			return signalsList.get(rowIndex).split("_")[1];
		case 1:
			Integer id = signalMap.get(signalsList.get(rowIndex));
			return ElementSim.getElement(id).getValue(id);
		default:
			break;
		}
		return null;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex){
		return columnIndex > 0 ? true : false;
	}

	@Override
	public void removeTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
	}

	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex){
		switch(columnIndex){
		case 1:
			Integer id = signalMap.get(signalsList.get(rowIndex));
			((Dynamicconnector)ElementSim.getElement(id)).setValue(Integer.parseInt(value.toString()));
			simGui.repaintPicture();
			break;
		}
	}
}
