package gui;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MemoryTableModel implements TableModel{
	private static final long serialVersionUID = 1L;

	private InterfaceSimGui iSG;
	private String[] columns = new String[]{"Address", "Value"};
	public MemoryTableModel(InterfaceSimGui iSG){
		this.iSG = iSG;
	}
	
	@Override
	public void addTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
	}

	@Override
	public Class<?> getColumnClass(int columnIndex){
		return columns[columnIndex].getClass();
	}

	@Override
	public int getColumnCount(){
		return columns.length;
	}

	@Override
	public String getColumnName(int columnIndex){
		return columns[columnIndex];
	}

	@Override
	public int getRowCount(){
		return 1 << iSG.getAddrCount();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex){
		switch(columnIndex){
		case 0:
			return Integer.toHexString(rowIndex);
		case 1:
			Integer temp = iSG.getMemory().get(rowIndex);
			return temp != null ? Integer.toHexString(temp) : 0;
		default:
			break;
		}
		return null;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex){
		return false;
	}

	@Override
	public void removeTableModelListener(TableModelListener l){
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex){
//		switch(columnIndex){
//		case 1:
//			list.get(rowIndex).setElementName(value.toString());
//			break;
//		case 2:
//			list.get(rowIndex).setType(Integer.parseInt(value.toString()));
//			break;
//		}
	}
}
