package elements;

import model.sim.*;

public class ALU extends ElementSim {
//	private int vrednost = 0;
	private int C8 = 0;
	/*
	 ulazi: 	0 - inA; 1 - inB; 2 - add; 3 - sub; 4 - or; 5 - inc; 6 - dec; 7 - and; 8 - xor; 9 - not; 10 - c0;
	 izlazi:	0 - out; 1 - c8;
	 */
	public ALU(int id, int[] ulazi, int[] izlazi, int vrednost, int brLinija, String oznaka){
		super(id, ulazi, izlazi, vrednost, brLinija, oznaka);		
	}
	
	public void execute(){
		int novaVrednost = 0;
		int nC8=0;
		int kontrolniSignal = 0;
		for(int i = 2; i < 10; i++){
			if (getElement(ins[i]).getValue(id) == 1)
				if (kontrolniSignal == 0)
					kontrolniSignal = i;
				else
					return;
		}
		int a = getElement(ins[0]).getValue(id);
		int b = getElement(ins[1]).getValue(id);
		int brLinija = getElement(ins[0]).getNumLines();
		
		switch(kontrolniSignal){
		case 3:
			b = parserInteger((~b)+1, 0, brLinija - 1);
			novaVrednost = parserInteger(a + b, 0, brLinija - 1);
			nC8 = (novaVrednost == a+b) ? 1 : 0;			
			break; 
		case 2:
			novaVrednost = parserInteger(a + b, 0, brLinija - 1);			
			nC8 = (novaVrednost == a+b) ? 0 : 1;			
			break;		
		case 4:
			novaVrednost = parserInteger(a | b, 0, brLinija - 1);
			nC8 = 0;			
			break;
		case 5:
			novaVrednost = parserInteger(a + 1, 0, brLinija - 1);			
			nC8 = (novaVrednost == a+1) ? 0 : 1;	
			break;
		case 6:			
			novaVrednost = parserInteger(a - 1, 0, brLinija - 1);
			nC8 = (novaVrednost == a - 1) ? 1 : 0;
			break;
		case 7:
			novaVrednost = parserInteger(a & b, 0, brLinija - 1);
			nC8 = 0;			
			break;
		case 8:
			novaVrednost = parserInteger(a ^ b, 0, brLinija - 1);
			nC8 = 0;			
			break;
		case 9:
			novaVrednost = parserInteger(~a , 0, brLinija - 1);
			nC8 = 0;			
			break;			
		}		
		if((novaVrednost != value) || (C8 != nC8)){
			value = novaVrednost;
			C8 = nC8;
			changingList.addElement(getElement(outs[0]));
			changingList.addElement(getElement(outs[1]));			
		}			
	}
	public int getValue(int iid){
		int izlaz = -1;
		for (int i = 0; i< outs.length; i++)
			if (outs[i] == iid){
				izlaz = i;
				break;
			}
		switch(izlaz){
		case 0:
			return value;
		case 1:
			return C8;				
		}
		return 0;
	}
	public void init(){
		value = 0;
		C8 = 0;
	}
}
