package xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import model.visio.ArcTo;
import model.visio.Connector;
import model.visio.EllipArcTo;
import model.visio.Geom;
import model.visio.LineTo;
import model.visio.Master;
import model.visio.MoveTo;
import model.visio.Output;
import model.visio.Page;
import model.visio.Shape;
import model.visio.TextXForm;
import model.visio.XForm;
import model.visio.XForm1D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import simgen.ElementModel;
import system.AppConstants;


public class VisioParser {
	private String fileName;
	private model.visio.Document obrada;
	private String masterName;
	private static int counter = 0;
	
	public VisioParser(String fileName, model.visio.Document obrada, String masterName){
		this.fileName = fileName;
		this.obrada = obrada;
		this.masterName = masterName;
	}
	
	public void parse(){
		try{
			Document doc = null;
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			XPathFactory xpathFactory = XPathFactory.newInstance();
			DocumentBuilder builder = null;
			builder = factory.newDocumentBuilder();
			InputStream fileIs = editXMLFile();
			doc = builder.parse(fileIs);
			XPath xpath = xpathFactory.newXPath();
			XPathExpression expr = null;
			
			// Masters
			expr = xpath.compile("//Master");
			Object result = expr.evaluate(doc, XPathConstants.NODESET);
			NodeList nodes = (NodeList) result;
			for(int i = 0; i < nodes.getLength(); i++){
				Node node = nodes.item(i);
				String masterName = "";
				String masterId = node.getAttributes().getNamedItem("ID").getNodeValue();
				Master master = new Master(masterId, masterName);
				if(node.getAttributes().getNamedItem("Name") != null){
					masterName = node.getAttributes().getNamedItem("Name").getNodeValue();
					master.setName(masterName);
				}else if(node.getAttributes().getNamedItem("NameU") != null){
					masterName = node.getAttributes().getNamedItem("NameU").getNodeValue();
					master.setName(masterName);
				}
				for(int j=0; j< node.getChildNodes().getLength(); j++){
					if("Shapes".equals(node.getChildNodes().item(j).getNodeName())){
						Node shape1Node = node.getChildNodes().item(j).getChildNodes().item(0);
						for(int k=0; k< shape1Node.getChildNodes().getLength(); k++){
							Node childNode = shape1Node.getChildNodes().item(k);
							if("Prop".equals(childNode.getNodeName())){
								NodeList nodeList = childNode.getChildNodes();
								String value = nodeList.item(0).getTextContent();
								String label = nodeList.item(2).getTextContent();
								master.addProperties(label, value);
							}
						}
					}
				}
				obrada.addMaster(master);
				NodeList masterCL = node.getChildNodes();
				// prvi shape u masteru
				Node masterShapeNode = masterCL.item(1).getChildNodes().item(0);
				Shape masterShape = createShape(masterShapeNode);
				master.addShape(masterShape);
			}
			
			// Pages
			expr = xpath.compile("//Page");
			nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
			for(int i = 0; i < nodes.getLength(); i++){
				Node node = nodes.item(i);
				Page page = createPage(node);
				obrada.addPage(page);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	private Shape createShape(Node node){
		String lineStyle = "-1";
		if(node.getAttributes().getNamedItem("LineStyle") != null){
			lineStyle = node.getAttributes().getNamedItem("LineStyle").getNodeValue();
		}
		String textStyle = "-1";
		if(node.getAttributes().getNamedItem("TextStyle") != null){
			textStyle = node.getAttributes().getNamedItem("TextStyle").getNodeValue();
		}
		String masterID = "-1";
		if(node.getAttributes().getNamedItem("Master") != null){
			masterID = node.getAttributes().getNamedItem("Master").getNodeValue();
		}
		Node xFormShape = node.getChildNodes().item(0);
		XForm xForm = createXForm(xFormShape);
		Shape shape = new Shape(masterID, xForm, lineStyle, textStyle);
		for(int i=0; i< node.getChildNodes().getLength(); i++){
			Node childNode = node.getChildNodes().item(i);
			if("Geom".equals(childNode.getNodeName())){
				Geom geom = createGeom(childNode);
				shape.addGeom(geom);
			}else if("Prop".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String value = nodeList.item(0).getTextContent();
				String label = nodeList.item(2).getTextContent();
				shape.addProperties(label, value);
			}else if("ConnectionABCD".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String x = nodeList.item(0).getTextContent();
				String y = nodeList.item(1).getTextContent();
				String d = nodeList.item(5).getTextContent();
				shape.addConnector(new Connector(x, y, d));
			}else if("Connection".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String x = nodeList.item(0).getTextContent();
				String y = nodeList.item(1).getTextContent();
				shape.addConnector(new Connector(x, y, "-1"));
			}else if("TextXForm".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String textPinX = nodeList.item(0).getTextContent();
				String textPinY = nodeList.item(1).getTextContent();
				String textWidth = nodeList.item(2).getTextContent();
				String textHeight = nodeList.item(3).getTextContent();
				String textLocPinX = nodeList.item(4).getTextContent();
				String textLocPinY = nodeList.item(5).getTextContent();
				String textAngle = nodeList.item(6).getTextContent();
				shape.setTextXForm(new TextXForm(textPinX, textPinY, textWidth, textHeight, textLocPinX, textLocPinY, textAngle));
			}else if("XForm1D".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String beginX = nodeList.item(0).getTextContent();
				String beginY = nodeList.item(1).getTextContent();
				String endX = nodeList.item(2).getTextContent();
				String endY = nodeList.item(3).getTextContent();
				shape.setXForm1D(new XForm1D(beginX, beginY, endX, endY));
			}else if("Text".equals(childNode.getNodeName())){
				String text = childNode.getTextContent();
				if(text.startsWith("$") || text.startsWith("#")){
					text = text.substring(0, text.length()-1) + "_" + counter++;
				}
				shape.setText(text);
			}else if("Char".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				String textSize = nodeList.item(6).getTextContent();
				shape.setSize(textSize);
			}else if("Shapes".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				for(int j = 0; j < nodeList.getLength(); j++){
					Shape newShape = createShape(nodeList.item(j));
					shape.addShape(newShape);
				}
			}
		}
		return shape;
	}
	
	private Geom createGeom(Node geomNode){
		NodeList geomNL = geomNode.getChildNodes();
		String noShow = geomNL.item(2).getTextContent();
		Geom geom = new Geom(noShow);
		for(int i=0; i< geomNode.getChildNodes().getLength(); i++){
			Node childNode = geomNode.getChildNodes().item(i);
			if("MoveTo".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				double x = Double.parseDouble(nodeList.item(0).getTextContent());
				double y = Double.parseDouble(nodeList.item(1).getTextContent());
				geom.addStreak(new MoveTo(x, y));
			}else if("LineTo".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				if(nodeList.item(0) != null){
					double x = Double.parseDouble(nodeList.item(0).getTextContent());
					double y = Double.parseDouble(nodeList.item(1).getTextContent());
					geom.addStreak(new LineTo(x, y));
				}
			}else if("ArcTo".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				double x = Double.parseDouble(nodeList.item(0).getTextContent());
				double y = Double.parseDouble(nodeList.item(1).getTextContent());
				double a = Double.parseDouble(nodeList.item(2).getTextContent());
				geom.addStreak(new ArcTo(x, y, a));
			}else if("EllipticalArcTo".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				double x = Double.parseDouble(nodeList.item(0).getTextContent());
				double y = Double.parseDouble(nodeList.item(1).getTextContent());
				double a = Double.parseDouble(nodeList.item(2).getTextContent());
				double b = Double.parseDouble(nodeList.item(3).getTextContent());
				double c = Double.parseDouble(nodeList.item(4).getTextContent());
				double d = Double.parseDouble(nodeList.item(5).getTextContent());
				geom.addStreak(new EllipArcTo(x, y, a, b, c, d));
			}
		}
		return geom;
	}
	
	private XForm createXForm(Node node){
		NodeList nodeList = node.getChildNodes();
		String pinX = nodeList.item(0).getTextContent();
		String pinY = nodeList.item(1).getTextContent();
		String width = nodeList.item(2).getTextContent();
		String height = nodeList.item(3).getTextContent();
		String locPinX = nodeList.item(4).getTextContent();
		String locPinY = nodeList.item(5).getTextContent();
		String angle = nodeList.item(6).getTextContent();
		String flipX = nodeList.item(7).getTextContent();
		String flipY = nodeList.item(8).getTextContent();
//		System.out.println("[CreateXForm]: " + pinX +" " + pinY+ " " + width + " " + height +" " +locPinX+" "+ locPinY+" " +angle+" "+ flipX+" "+ flipY);
		return new XForm(pinX, pinY, width, height, locPinX, locPinY, angle, flipX, flipY);
	}
	
	private Page createPage(Node node){
		String pageWidth = "";
		String pageHeight = "";
		String name = "";
		if(node.getAttributes().getNamedItem("Name") != null){
			name = node.getAttributes().getNamedItem("Name").getNodeValue();
		}else if(node.getAttributes().getNamedItem("NameU") != null){
			name = node.getAttributes().getNamedItem("NameU").getNodeValue();
		}
		XForm xForm = null;
		Page page = null;
		for(int i = 0; i < node.getChildNodes().getLength(); i++){
			Node childNode = node.getChildNodes().item(i);
			if("PageSheet".equals(childNode.getNodeName())){
//				NodeList nodeList = childNode.getChildNodes();
				for(int j = 0; j < childNode.getChildNodes().getLength(); j++){
					Node chChNode = childNode.getChildNodes().item(j);
					if("PageProps".equals(chChNode.getNodeName())){
						NodeList nodeList = chChNode.getChildNodes();
						pageWidth = nodeList.item(0).getTextContent();
						pageHeight = nodeList.item(1).getTextContent();
					}else if("XForm".equals(chChNode.getNodeName())){
						xForm = createXForm(chChNode);
					}
				}
				String pageName = masterName.contains("Module") ? masterName : name.replace(".", "_");
				page = new Page(pageName, pageWidth, pageHeight, xForm);
			}else if("Shapes".equals(childNode.getNodeName())){
				NodeList nodeList = childNode.getChildNodes();
				for(int j = 0; j < nodeList.getLength(); j++){
					Shape shape = createShape(nodeList.item(j));
					page.addShape(shape);
				}
			}
		}
		return page;
	}
	
	private InputStream editXMLFile(){
		try{
			File file = new File(fileName);
			ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
			ByteArrayInputStream byteInput = null;
			BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(byteArray));
			FileReader  fileR = new FileReader(file);
			BufferedReader brStore = new BufferedReader(fileR);
			String incomming;
			while((incomming = brStore.readLine()) != null){
				writer.write(incomming.replace("xmlns='http://schemas.microsoft.com/visio/2003/core'", "") + "\n");
			}
			writer.flush();
			byteInput = new ByteArrayInputStream(byteArray.toByteArray());
			writer.close();
			brStore.close();
			fileR.close();
			return byteInput;
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public void createConfigXMLFile(String fileName){
		try{
			LinkedList<ElementModel> elementModelList = getElements("elements");
			String root = "root";
			DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder documentBuilder =  documentBuilderFactory.newDocumentBuilder();
			Document document = documentBuilder.newDocument();
			Element rootElement = document.createElement(root);
			document.appendChild(rootElement);
		    for(ElementModel elementModel : elementModelList){
		    	String element = "element";
		    	Element em = document.createElement(element);
		    	em.setAttribute("className", elementModel.getClassName());
		    	em.setAttribute("elementName", elementModel.getElementName());
		    	em.setAttribute("type", elementModel.getType()+"");
		    	rootElement.appendChild(em);
		    }
		    TransformerFactory transformerFactory = TransformerFactory.newInstance();
		    Transformer transformer;
		
			transformer = transformerFactory.newTransformer();
			DOMSource source = new DOMSource(document);
			StreamResult result =  new StreamResult(new File(fileName));
			transformer.transform(source, result);
		}catch(TransformerConfigurationException e){
			e.printStackTrace();
		}catch(TransformerException e){
			e.printStackTrace();
		}catch(ParserConfigurationException e){
			e.printStackTrace();
		}
	}
	
	public LinkedList<ElementModel> getElements(String folderName){
		LinkedList<ElementModel> elementModelList = new LinkedList<ElementModel>();
		String elementName = "";
		File folder = new File("src\\" + folderName);
		File[] files = folder.listFiles();
		for(int i = 0; i < files.length; i++){
			elementName = files[i].getName().split(".java")[0];
			elementModelList.add(new ElementModel(elementName, elementName, ElementModel.SINGLE_TYPE));
		}
		return elementModelList;
	}
	
	public static void run(String projectName, String visioFile){
		model.visio.Document visioDocument = new model.visio.Document();
		VisioParser parserSim = new VisioParser(AppConstants.VISIO_DIR + visioFile, visioDocument, "");
		System.out.println("Zapoceo parsiranje");
		parserSim.parse();
		System.out.println("Zavrsio parsiranje");
		Output.init();
		System.out.println("Zapoceo obradu");
		visioDocument.execute(projectName);
		System.out.println("Zavrsio obradu");
		try{
			FileWriter file = new FileWriter(AppConstants.PROJECTS_DIR + projectName + "/" + AppConstants.GUI_XML);
			Output.outToFile(file);
		}catch(IOException ioe){
			ioe.printStackTrace();
		}
		parserSim.createConfigXMLFile(AppConstants.PROJECTS_DIR + projectName + "/" + AppConstants.CONFIG_XML);
	}
	
	public static void main(String[] args){
		model.visio.Document visioDocument = new model.visio.Document();
		VisioParser parserSim = new VisioParser(AppConstants.VISIO_DIR + "proba.vdx", visioDocument, "");
		System.out.println("Zapoceo parsiranje");
		parserSim.parse();
		System.out.println("Zavrsio parsiranje");
		Output.init();
		System.out.println("Zapoceo obradu");
		visioDocument.execute("");
		System.out.println("Zavrsio obradu");
		try{
			FileWriter file = new FileWriter(AppConstants.XML_DIR + AppConstants.GUI_XML);
			Output.outToFile(file);
		}catch(IOException ioe){
			ioe.printStackTrace();
		}
		parserSim.createConfigXMLFile(AppConstants.XML_DIR + AppConstants.CONFIG_XML);
	}
}
