package simgen;

import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import system.AppConstants;
import system.FileUtils;
import xml.VisioParser;

public class SimGenGui extends JFrame implements GuiListener{
	
	private static final long serialVersionUID = 1L;
	
	private JScrollPane jScrollPane1;
	private JScrollPane outputScroll;
	private JTextArea outputText;
	private JButton newProject;
	private JButton run;
	private JButton config;
	private JButton close;
	private JButton delete;
	private JList list;
	private DefaultListModel listModel = new DefaultListModel();
	private SimGenModel testModel;
	private String[] strings;
	private String projectName;
	private String visioFileName;
	
	public SimGenGui(SimGenModel testModell){
		super("SimGen");
	    this.testModel = testModell;
	    testModel.addListener(this);
	    initComponents();
	    init();
	    setVisible(true);
	}
	
	private void initComponents(){
		jScrollPane1 = new javax.swing.JScrollPane();
        list = new javax.swing.JList();
        run = new javax.swing.JButton();
        config = new javax.swing.JButton();
        newProject = new javax.swing.JButton();
        close = new javax.swing.JButton();
        delete = new javax.swing.JButton();
        outputScroll = new javax.swing.JScrollPane();
        outputText = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBounds(new java.awt.Rectangle(300, 200, 0, 0));

        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder("Projects list"));

        list.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        list.setModel(listModel);
        list.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                listMouseClicked(evt);
            }
        });
        list.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                listValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(list);

        run.setText("Run");
        run.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                runActionPerformed(evt);
            }
        });

        config.setText("Config");
        config.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                configActionPerformed(evt);
            }
        });

        newProject.setText("New project");
        newProject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newProjectActionPerformed(evt);
            }
        });

        close.setText("Close");
        close.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeActionPerformed(evt);
            }
        });

        delete.setText("Delete");
        delete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteActionPerformed(evt);
            }
        });

        outputScroll.setBorder(javax.swing.BorderFactory.createTitledBorder("Output"));

        outputText.setColumns(20);
        outputText.setEditable(false);
        outputText.setRows(5);
        outputScroll.setViewportView(outputText);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(outputScroll, javax.swing.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(26, 26, 26)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(close, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(run, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(config, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(delete, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(newProject, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(run)
                        .addGap(18, 18, 18)
                        .addComponent(config)
                        .addGap(18, 18, 18)
                        .addComponent(delete)
                        .addGap(18, 18, 18)
                        .addComponent(newProject)
                        .addGap(18, 18, 18)
                        .addComponent(close))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18)
                .addComponent(outputScroll, javax.swing.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE))
        );

        pack();
    }
	
	private void init(){
		listModel.clear();
		String[] projects = new File(AppConstants.PROJECTS_DIR).list();
		for(int i=0; i<projects.length; i++){
			listModel.addElement(projects[i]);
		}
	}

    private void listMouseClicked(MouseEvent evt) {
    	if(!list.isSelectionEmpty() && evt.getClickCount()==2 && evt.getButton()==MouseEvent.BUTTON1){
    		runActionPerformed(null);
    	}
    }
    private void listValueChanged(javax.swing.event.ListSelectionEvent evt){
    	if(list.getSelectedValue() != null){
    		testModel.setCurrentProject(list.getSelectedValue().toString());
    	}
    }

    private void runActionPerformed(java.awt.event.ActionEvent evt){
    	try{
            Process p = Runtime.getRuntime().exec("java -cp bin gui.SimGui " + testModel.getCurrentProject());
            outputText.append("Pokrenut je projekat '" + testModel.getCurrentProject() + "'!\n");
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
    		String x;
    		while((x = r.readLine()) != null){
    			System.out.println(x);
    		}
    		r.close();
    		p.waitFor();
        } catch (IOException ex) {
            ex.printStackTrace();
        }catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
    
    private void closeActionPerformed(java.awt.event.ActionEvent evt) {
        this.dispose();
    }
    
    private void deleteActionPerformed(java.awt.event.ActionEvent evt){
    	int res = JOptionPane.showConfirmDialog(this, AppConstants.DELETE_MESSAGE, "Delete project", JOptionPane.YES_NO_OPTION);
    	if(res == JOptionPane.YES_OPTION){
	    	if(FileUtils.deleteDir(new File(AppConstants.PROJECTS_DIR + testModel.getCurrentProject()))){
	        	System.out.println("Projekat '" + testModel.getCurrentProject() + "' je obrisan.");
	        	outputText.append("Projekat '" + testModel.getCurrentProject() + "' je obrisan.\n");
	        }else{
	        	System.out.println("ERROR!!! Projekat '" + testModel.getCurrentProject() + "' nije obrisan.");
	        	outputText.append("ERROR!!! Projekat '" + testModel.getCurrentProject() + "' nije obrisan.\n");
	        }
	        init();
    	}
    }
    
    private void configActionPerformed(java.awt.event.ActionEvent evt){
    	if(testModel.getCurrentProject() != null){
	    	testModel.init(AppConstants.PROJECTS_DIR + testModel.getCurrentProject() + "/config.xml");
	    	ElementsDialog elementsDialog = new ElementsDialog(this, testModel, "ElementsConfig");
			List<String> selected = elementsDialog.showDialog();
    	}
    }

    private void newProjectActionPerformed(java.awt.event.ActionEvent evt) {
    	NewProjectDialog newProjectDialog = new NewProjectDialog(this, "NewProject");
		String[] selected = newProjectDialog.showDialog();
		projectName = selected[0];
		visioFileName = selected[1];
		if("".equals(projectName) || "".equals(visioFileName)){
			System.out.println("ERROR!!! Niste uneli sve podatke!");
			outputText.append("ERROR!!! Niste uneli sve podatke!\n");
			return;
		}
		try{
			if(new File(AppConstants.PROJECTS_DIR + projectName).mkdir()){
				new system.ProgressBar(this, "Creating project..."){
					@Override
					protected Void doInBackground(){
						VisioParser.run(projectName, visioFileName);
						System.out.println("Projekat '" + projectName + "' je kreiran.");
						listModel.addElement(projectName);
						outputText.append("Projekat '" + projectName + "' je kreiran.\n");
						return null;
					}
				};
			}else{
				System.out.println("ERROR!!! Projekat '" + projectName + "' nije kreiran");
				outputText.append("ERROR!!! Projekat '" + projectName + "' nije kreiran\n");
			}
		}catch(Exception e){
			e.printStackTrace();
		}
    }
    
    @Override
    public void onChanged(String s){
    	outputText.append(s);
    }
    
	public static void main(String[] args){
		SimGenModel testModel = SimGenModel.getInstance();
		testModel.init(AppConstants.XML_DIR + "config.xml");
		new SimGenGui(testModel);
	}
}
