package simgen;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ElementsDialog extends JDialog{
	private static final long serialVersionUID = 1L;
	private JButton cancel;
	private JButton save;
	private JButton add;
	private SimGenModel testModel;
	private JTable table;
	private ElementsTableModel elementsTableModel;
	
	public ElementsDialog(Window parent, SimGenModel testModel, String title){
		super(parent);
		this.testModel = testModel;
		setBounds(100, 100, 500, 600);
		setTitle(title);
		initComponents();
	}
		
	private void initComponents(){
		JPanel jPanel1 = new JPanel();
		cancel = new JButton();
		cancel.setPreferredSize(new Dimension(75, 25));
		cancel.setText("Cancel");
		cancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				cancelActionPerformed(evt);
			}
		});
		save = new JButton();
		save.setPreferredSize(new Dimension(75, 25));
		save.setText("Save");
		save.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				okActionPerformed(evt);
			}
		});
		save.setSize(50, 20);
		add = new JButton();
		add.setPreferredSize(new Dimension(75, 25));
		add.setText("Add");
		add.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				addActionPerformed(evt);
			}
		});
		add.setSize(50, 20);
		jPanel1.add(save);
		jPanel1.add(cancel);
		jPanel1.add(add);
		add(jPanel1, "South");
		setModal(true);
		setResizable(false);
		
		elementsTableModel = new ElementsTableModel(testModel.getElemetnModelList());
		table = new JTable(elementsTableModel);
		
		JScrollPane scrollPane = new JScrollPane(table); 
		add(scrollPane, "Center");
	}

	private void okActionPerformed(ActionEvent evt){
		LinkedList<ElementModel> elementModelList = new LinkedList<ElementModel>();
		String fileName = "";
		String elementName = "";
		int type = ElementModel.SINGLE_TYPE;
		for(int i = 0; i < elementsTableModel.getRowCount(); i++){
			fileName = elementsTableModel.getValueAt(i, 0).toString();
			elementName = elementsTableModel.getValueAt(i, 1).toString();
			type = Integer.parseInt(elementsTableModel.getValueAt(i, 2).toString());
			elementModelList.add(new ElementModel(fileName, elementName, type));
		}
		testModel.saveElementsModel(elementModelList);
		setVisible(false);
	}
	
	private void addActionPerformed(ActionEvent evt){
		ClassDialog classDialog = new ClassDialog(this, testModel, "ElementsConfig");
		String selected = classDialog.showDialog();
		if(selected != null){
			ElementModel element = new ElementModel(selected, selected, 1);
			elementsTableModel.addElement(element);
			table.revalidate();
			repaint();
		}
	}

	private void cancelActionPerformed(ActionEvent evt) {
		setVisible(false);
	}

	public List<String> showDialog(){
		setVisible(true);
		return null;
	}
}
