package simgen;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClassDialog extends JDialog{
	private static final long serialVersionUID = 1L;
	private JButton cancel;
	private JButton ok;
	private SimGenModel testModel;
	private JComboBox comboBox;
	private String selected;
	
	public ClassDialog(Window parent, SimGenModel testModel, String title){
		super(parent);
		this.testModel = testModel;
		setBounds(parent.getWidth()/2, parent.getHeight()/2-60, 300, 120);
		setTitle(title);
		initComponents();
	}
		
	private void initComponents(){
		JPanel jPanel1 = new JPanel();
		cancel = new JButton();
		cancel.setPreferredSize(new Dimension(75, 25));
		cancel.setText("Cancel");
		cancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				cancelActionPerformed(evt);
			}
		});
		ok = new JButton();
		ok.setPreferredSize(new Dimension(75, 25));
		ok.setText("Ok");
		ok.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				okActionPerformed(evt);
			}
		});
		ok.setSize(50, 20);
		jPanel1.add(ok);
		jPanel1.add(cancel);
		add(jPanel1, "South");
		setModal(true);
		setResizable(false);
		
		JLabel label = new JLabel("Class element");
		comboBox = new JComboBox(testModel.getAllClasses("elements"));
		JPanel jPanel2 = new JPanel();
		jPanel2.add(label);
		jPanel2.add(comboBox);
		add(jPanel2, "Center");
	}

	private void okActionPerformed(ActionEvent evt){
		selected = comboBox.getSelectedItem().toString();
		setVisible(false);
	}
	
	private void cancelActionPerformed(ActionEvent evt){
		selected = null;
		setVisible(false);
	}

	public String showDialog(){
		setVisible(true);
		return selected;
	}
}
