package parsiranjeKoda;
import java.util.*;

public class Instrukcija {
	public static final int F_BEZADRESNI = 0, F_PREK = 1, F_B = 2, F_J = 3, F_R = 4, F_IB = 5, F_IW = 6, F_AP = 7;
	private int adresa;
	private int format;
	private int kod;
	private Adresiranje adresiranje;	
	public static int parserInteger(int broj, int indeks1, int indeks2){
		
		return  (broj>>indeks1) & ((1<<(indeks2-indeks1+1))-1);
	}
	public Instrukcija(int aadresa, int fformat, int kkod, Adresiranje aadresiranje){
		adresa = aadresa;
		format = fformat;
		kod = kkod;
		adresiranje = aadresiranje;
	}
	public int brBajtova(){
		switch (format){
		case F_BEZADRESNI:
			return 1;
		case F_PREK:
			return 2;
		case F_B:
			return 2;
		case F_J:
			return 3;
		case F_R:
			return 2;
		case F_IB:
			return 3;
		case F_IW:
			return 4;
		case F_AP:
			return 4;
		}
		return -1;
	}
	
	public int uzmiBajt(int iindeks, Hashtable ttabela){
		switch (format){
		case F_BEZADRESNI:
			return kod;
		case F_PREK:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				return parserInteger(adresiranje.uzmiKonst(), 0, 7);
			}
		case F_B:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				if (adresiranje.uzmiLabelu() =="")
					return parserInteger(adresiranje.uzmiKonst(), 0, 7);
				else{
					Integer apsAdd = (Integer) ttabela.get(adresiranje.uzmiLabelu());
					return parserInteger(apsAdd.intValue()-adresa, 0 , 7);
				}					
			}
		case F_J:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				if (adresiranje.uzmiLabelu() == "")
					return parserInteger(adresiranje.uzmiKonst(), 8, 15);
				else{
					Integer apsAdd = (Integer) ttabela.get(adresiranje.uzmiLabelu());
					return parserInteger(apsAdd.intValue(), 8, 15);
				}
			case 2:
				if (adresiranje.uzmiLabelu() == "")
					return parserInteger(adresiranje.uzmiKonst(), 0, 7);
				else{
					Integer apsAdd = (Integer) ttabela.get(adresiranje.uzmiLabelu());
					return parserInteger(apsAdd.intValue(), 0, 7);
				}
			}
		case F_R:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				return (adresiranje.uzmiTip()<<5) | adresiranje.uzmiReg();					
			}
		case F_IB:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				return adresiranje.uzmiTip()<<5;
			case 2:				 
				return parserInteger(adresiranje.uzmiKonst(), 0, 7);									
			}
		case F_IW:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				return adresiranje.uzmiTip()<<5;
			case 2:				 
				return parserInteger(adresiranje.uzmiKonst(), 8, 15);
			case 3:				 
				return parserInteger(adresiranje.uzmiKonst(), 0, 7);
			}
		case F_AP:
			switch(iindeks){
			case 0:
				return kod;
			case 1:
				if (adresiranje.uzmiTip()<4)
					return (adresiranje.uzmiTip()<<5);
				else
					return (adresiranje.uzmiTip()<<5) | adresiranje.uzmiReg();
			case 2:
				if (adresiranje.uzmiTip()<4 && adresiranje.uzmiLabelu()!=""){
					Integer apsAdd = (Integer) ttabela.get(adresiranje.uzmiLabelu());
					return parserInteger(apsAdd.intValue()-adresa, 8, 15);
				}else
					return parserInteger(adresiranje.uzmiKonst(), 8, 15);
			case 3:				 
				if (adresiranje.uzmiTip()<4 && adresiranje.uzmiLabelu()!=""){
					Integer apsAdd = (Integer) ttabela.get(adresiranje.uzmiLabelu());
					return parserInteger(apsAdd.intValue()-adresa, 0, 7);
				}else
					return parserInteger(adresiranje.uzmiKonst(), 0, 7);			
			}
			
		}
		return -1;
	}
	public int uzmiAdresu(){
		return adresa;
	}
	public String toString(){
		return adresa +" " +kod+"";
	}
}