package model.visio;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import system.AppConstants;

public class Simulation{
	private static Hashtable<String, SimElement> linesMap = new Hashtable<String, SimElement>();
	
	private List<Connector> connectors = new LinkedList<Connector>();
	
	private static ArrayList<SimElement> circuits = new ArrayList<SimElement>();
	private static ArrayList<SimElement> linesList = new ArrayList<SimElement>();
	
	private static Map<String, Module> modulsMap = new HashMap<String, Module>();
	
	public final static String PREFIX = "_$_";
	public static int moduleCount = 0;
	
	static{
		SimElement const_1 = new SimElement(new Master("1000", "Const"), 1);
		SimElement const_0 = new SimElement(new Master("1001", "Const"), 0);
		SimElement takt = new SimElement(new Master("1003", "Takt"));
		SimElement clk = new SimElement(new Master("1004", "Dynamic connector"));
		takt.addOut(0, clk);
		clk.addIn(0, takt);
		linesMap.put("clk", clk);
		circuits.add(takt);
		linesList.add(clk);
		linesList.add(const_1);
		linesList.add(const_0);
		
	}
	
	public static void obradaDC(SimElement ddc){
		String prefix = ddc.getPrefix();
		int count = ddc.getCount();
		if(!"".equals(prefix) && count > 2){
			for(int i=1; i<count; i++){
				SimElement line = (SimElement) linesMap.get(prefix + Integer.toString(i, 16));
				if(line == null){
					line = new SimElement(new Master("1004", "Dynamic connector"));
					linesMap.put(prefix + Integer.toString(i, 16), line);				
					linesList.add(line);
				}
				line.setText(prefix+Integer.toString(i, 16));
				ddc.addOut(i, line);
				line.addNextIn(ddc);			
			}		
			ddc.addIn(0, new SimElement(-2)); //????? bilo je -2!!!
		}
	}
	
	public Simulation(){ 
		
	}
	
	public void addConnector(Connector connector){
		connectors.add(connector);
	}
			
	public Connector getConnector(Point point){
		for(Connector connector : connectors){
			if(connector.getPoint().equals(point))
				return connector;
		}
		return null;		
	}
		
	public static void addCircuit(SimElement simElem){
		circuits.add(simElem);
	}
	
	public static void addLine(SimElement simElem){
		linesList.add(simElem);
	}
	
	public static void putLine(String key, SimElement simElem){
		linesMap.put(key, simElem);
	}
	
	public static SimElement getLine(String key){
		return linesMap.get(key);
	}
	
	public static void putModule(String key, Module module){
		modulsMap.put(key, module);
	}
	
	public static Module getModule(String key){
		return modulsMap.get(key);
	}
	
	public static Map<String, Module> getModules(){
		return new HashMap<String, Module>(modulsMap);
	}
	
	public static void outToFile(String projectName){
		if(!"".equals(projectName)){
			projectName += "/";
		}
		try{
			Writer w = new FileWriter(AppConstants.PROJECTS_DIR + projectName + AppConstants.SIM_XML);
			String s = new String("<root>\n");
			for(SimElement simElem : circuits){
				s += simElem;
			}
			for(SimElement simElem : linesList){
				s += simElem;
			}
			s+="</root>";
			w.write(s);
			w.close();
		}catch(IOException e){
			e.printStackTrace();
		}
	}
}
