package model.visio;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import system.AppConstants;

public class Shape{
	private int masterId;
	private String masterName = "";
	private String shapeName = "";
	private XForm xf;
	private XForm1D xf1d;
	private int lineStyle;
	private int textStyle;
	private Master master;
	private String size = "10";
	
	private int elemId=-1;
	
	private Map<String, String> properties = new HashMap<String, String>();
	private String text = null;
	private TextXForm txf;
	
	private List<Geom> geoms = new LinkedList<Geom>();
	private List<Shape> shapes = new LinkedList<Shape>();
	private List<Connector> connectors = new LinkedList<Connector>();
	
	public Shape(String masterId, XForm xf, String lineStyle, String textStyle){
		this.masterId = Integer.parseInt(masterId);
		this.xf = xf;
		this.lineStyle = Integer.parseInt(lineStyle);
		this.textStyle = Integer.parseInt(textStyle);
	}
	
	public int getMasterId(){
		return masterId;
	}

	public void setMasterId(int masterId){
		this.masterId = masterId;
	}
	
	public void setSize(String size){
		this.size = size;
	}
	
	public void addProperties(String key, String value){
		properties.put(key, value);
	}
		
	public void addGeom(Geom geom){
		geoms.add(geom);
	}
	
	public void addShape(Shape shape){
		shapes.add(shape);
	}
	
	public void addConnector(Connector connector){
		connectors.add(connector);
	}
	
	public void setTextXForm(TextXForm txf){
		this.txf = txf;		
	}
	
	public void setXForm1D(XForm1D xf1d){
		this.xf1d = xf1d;
	}
	
	public void setText(String text){
		this.text = text.trim();
	}
	
	public String getText(){
		return text;
	}
	
	public int getLineStyle(){
		return lineStyle;
	}
	
	public int getTextStyle(){
		return textStyle;
	}
	
	public LinkedList<Geom> getGeoms(){
		return new LinkedList<Geom>(geoms);
	}
	
	public LinkedList<Shape> getShapes(){
		return new LinkedList<Shape>(shapes);
	}
	
	public String toString(){
		String s = "";
		for(Geom geom : geoms){
			s += geom + "\n";
		}
		
		for(Shape shape : shapes){
			s += shape + "\n";
		}
		return s;
	}
	
	public void initMaster(Shape masterShape){
		if(geoms.size() == 0){
			for(Geom geom : masterShape.getGeoms()){
				geoms.add(geom.clone());
			}
		}
		if(text == null){
			text = masterShape.getText();
		}
		if(lineStyle == -1){
			lineStyle = masterShape.getLineStyle();
		}
		if(textStyle == -1){
			textStyle = masterShape.getTextStyle();
		}
		for(int i=0; i < Math.min(shapes.size(), masterShape.getShapes().size());i++){
			shapes.get(i).initMaster((Shape)masterShape.getShapes().get(i));
		}
	}
	
	public void executeSim(Document document, Hashtable<Integer, Master> masters, XForm xf, Simulation simPage, SimElement simElem){
		StaticElem staticElem = null;
		if(properties.containsKey(AppConstants.NAME)){
			shapeName = properties.get(AppConstants.NAME);
		}
		if(masterId!=-1){
			master = masters.get(new Integer(masterId));
			masterName = master.getName();
			initMaster(master.getShape(0));
			if(!"Dynamicconnector".equals(masterName) && !masterName.contains("Module")){
				simElem = new SimElement(master);
				if(properties.containsKey(AppConstants.TEXT)){
					simElem.setText(properties.get(AppConstants.TEXT));
				}
				if(properties.containsKey(AppConstants.COUNT)){
					int value = Integer.parseInt(properties.get(AppConstants.COUNT), 16);
					simElem.setCount(value);
				}
				if(properties.containsKey(AppConstants.VALUE)){
					int value = Integer.parseInt(properties.get(AppConstants.VALUE), 16);
					simElem.setValue(value);
				}
				if(properties.containsKey(AppConstants.PREFIX)){
					simElem.setPrefix(properties.get(AppConstants.PREFIX));
				}
				Simulation.addCircuit(simElem);
			}
			if(masterName.contains("Module")){
				staticElem = new StaticElem();
				String prefix = Simulation.PREFIX + Simulation.moduleCount++;
				Module module = new Module(shapeName, prefix, staticElem, new Document(), masterName);
				shapeName = shapeName + prefix;
				Simulation.putModule(shapeName, module);
				document.putModule(shapeName, module);
			}
		}
		this.xf.recalculate(xf);
		if(txf != null){
			txf.recalculate(this.xf);
		}
		if(xf1d != null){
			xf1d.recalculate();
		}
		for(Geom geom : geoms){
			geom.recalculate(this.xf);
		}
		for(Connector conn : connectors){
			conn.recalculate(this.xf);
			if(simElem != null){
				conn.addSimElem(simElem);
				simPage.addConnector(conn);				
			}
			if(staticElem != null){
				conn.addStaticElem(staticElem);
				simPage.addConnector(conn);
			}
			
			if("Dynamicconnector".equals(masterName)){
				simPage.addConnector(conn);
			}
		}	
		for(Shape shape : shapes){
			shape.executeSim(document, masters, this.xf, simPage, simElem);
		}
	}
		
	public void executeSimLines(Simulation simPage, ModuleParam moduleParam){
		if("Dynamicconnector".equals(masterName)){
			SimElement line = null;
			String sufix = ("1".equals(text) || "0".equals(text) || "clk".equals(text)) ? "" : moduleParam.getSufix();
			if(text != null && text.startsWith("$") && moduleParam != null){
				int v = Integer.parseInt(text.substring(1, text.lastIndexOf("_")));
				line = moduleParam.getIns()[v];
			}else if(text != null && text.startsWith("#") && moduleParam != null){
				int v = Integer.parseInt(text.substring(1, text.lastIndexOf("_")));
				line = moduleParam.getOuts()[v];
			}else if(text != null && !text.equals("val")){
				line = Simulation.getLine(text.trim().concat(sufix));
			}
			if(line == null){
				line = new SimElement(master);
				if(text != null){
					Simulation.putLine(text.trim().concat(sufix), line);
				}
				Simulation.addLine(line);
			}
			if(properties.containsKey(AppConstants.TEXT)){
				line.setText(properties.get(AppConstants.TEXT));
			}
			if(properties.containsKey(AppConstants.COUNT)){
				int value = Integer.parseInt(properties.get(AppConstants.COUNT), 16);
				line.setCount(value);
			}
			if(properties.containsKey(AppConstants.VALUE)){
				int value = Integer.parseInt(properties.get(AppConstants.VALUE), 16);
				line.setValue(value);
			}
			
			elemId = line.getId();
			
			// nadovezivanje linija
			for(Connector connector : connectors){
				if(connector.getSimElem() == null){
					connector.addSimElem(line);
				}else{
					connector.getSimElem().addNextIn(line);
					line.addNextOut(connector.getSimElem());
				}
			}
			
			Connector connBegin = simPage.getConnector(xf1d.getBegin());
			if(connBegin != null){
				SimElement circle = connBegin.getSimElem();
				StaticElem staticElem = connBegin.getStaticElem();
				if(circle != null){
					if(connBegin.getD() == -1){
						if(circle != line){
							circle.addNextOut(line);
							line.addNextIn(circle);
						}
					}else if(connBegin.getD() < 100){
						circle.addIn(connBegin.getD(), line);
						line.addNextOut(circle);
					}else{
						circle.addOut(connBegin.getD()-100, line);
						line.addNextIn(circle);
					}
				}else if(staticElem != null){
					if(connBegin.getD() == -1){
						staticElem.addNextOut(line);
					}else if(connBegin.getD() < 100){
						staticElem.addIn(connBegin.getD(), line);
					}else{
						staticElem.addOut(connBegin.getD()-100, line);
					}
				}else{
					connBegin.addSimElem(line);
				}
			}
			Connector connEnd = simPage.getConnector(xf1d.getEnd());
			if(connEnd != null){
				SimElement circle = connEnd.getSimElem();
				StaticElem staticElem = connEnd.getStaticElem();
				if(circle != null){
					if(connEnd.getD() == -1){
						if(circle != line){
							circle.addNextOut(line);
							line.addNextIn(circle);
						}
					}else if(connEnd.getD() < 100){
						circle.addIn(connEnd.getD(), line);
						line.addNextOut(circle);
					}else{
						circle.addOut(connEnd.getD()-100, line);
						line.addNextIn(circle);
					}
				}else if(staticElem != null){
					if(connEnd.getD() == -1){
						staticElem.addNextOut(line);
					}else if(connEnd.getD() < 100){
						staticElem.addIn(connEnd.getD(), line);
					}else{
						staticElem.addOut(connEnd.getD()-100, line);
					}
				}else{
					connEnd.addSimElem(line);
				}
			}
		}
		
		for(Shape shape : shapes){
			shape.executeSimLines(simPage, moduleParam);
		}
	}
	public void executeGui(Hashtable<String, Page> pages, Container currentContainer, String param){
		if("Dynamicconnector".equals(masterName)){
			currentContainer.appendLines("<Line id='" + elemId + "' " + xf + ">");			
			for(Geom geom : geoms){
				currentContainer.appendLines(geom + "\n");
			}
			for(Shape shape : shapes){
				shape.executeGui(pages, currentContainer, masterName);
			}
			if(text!=null){
				currentContainer.appendLines("<Text " + ((txf != null) ? txf: xf.textXForm()) + " size='10' text='" + text.trim() + "'/>\n");
			}
			currentContainer.appendLines("</Line>\n");
			return;
		}
		if(masterName.contains("Kontejner") || shapeName.contains("Kontejner") || shapeName.contains("Container")){
			System.out.println("Naso Kontejner---------" + shapeName + " : " + masterId);
			Page page = pages.get(shapeName);
//			Page page = pages.get(masterName);
			Container container = new Container();
			page.executeGui(pages, container, xf);
			currentContainer.addContainer(container);
		}
		if(masterName.contains("Module")){
			Module module = Simulation.getModule(shapeName);
//			module.getObrada().executeModuleGui(masterName);
			Page page = module.getObrada().getPage(masterName);
			Container container = new Container();
			page.executeGui(module.getObrada().getPages(), container, xf);
			currentContainer.addContainer(container);
		}
		if(param.equals(masterName)){
			for(Geom geom : geoms){
				currentContainer.appendLines(geom + "\n");
			}
			if(text != null){	
				currentContainer.appendLines("<Text " + ((txf != null) ? txf : xf.textXForm()) + "size='" + size + "' text='" + text.trim() + "' />\n");
			}
		}
		if(param.equals("Page")){
			if(lineStyle !=1){
				for(Geom geom : geoms){
					currentContainer.appendShape(geom + "\n");
				}
			}
			if(text!=null){
				currentContainer.appendShape("<Text " + ((txf != null) ? txf : xf.textXForm()) + "size='" + size + "' text='" + text.trim() + "'/>\n");	
			}
		}
		for(Shape shape : shapes){
			shape.executeGui(pages, currentContainer, param);
		}
	}
}
